package pl.topteam.utils.wydruki.zmienne.utils;

import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;

public class ClassPathScanningCandidateProvider extends ClassPathScanningCandidateComponentProvider {

	public ClassPathScanningCandidateProvider(boolean useDefaultFilters) {
		super(useDefaultFilters);
	}

	/**
	 * Oprócz klas niezależnych (nie zagnieżdzonych itp.) dopuszczaj
	 * także możliwość przyporządkowywania udostępniania zmiennych przez
	 * klasy abstrakcyjne.
	 */
	@Override
	protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
		return beanDefinition.getMetadata().isIndependent();
	}
}
