--// migracja poprawek recept.
-- Migration SQL that makes the change goes here.

DELETE FROM PRACOWNIK_PARAMETR p WHERE p.TYP = 'INFO_WERSJA_APLIKACJI';

DROP VIEW AKTUALNE_DAWKI_LEKOW IF EXISTS;

CREATE VIEW AKTUALNE_DAWKI_LEKOW AS
  SELECT ewDps.OSOBA_ID, d.*
    FROM AKTUALNE_WPISY_EWIDENCJI_OSOB ewDps
      JOIN DAWKOWANIE d ON d.EWIDENCJA_DPS_ID = ewDps.ID
        AND d.DATA_OD <= CURRENT_DATE()
      LEFT OUTER JOIN DAWKOWANIE najD ON najD.EWIDENCJA_DPS_ID = ewDps.ID
        AND najD.POPRZEDNIE_DAWKOWANIE_ID = d.ID
  WHERE
    najD.ID IS NULL;
    
ALTER TABLE RECEPTA ADD PRACOWNIK_WYSTAWIL_ID BIGINT(10);
UPDATE RECEPTA SET PRACOWNIK_WYSTAWIL_ID = (SELECT ID FROM PRACOWNIK LIMIT 1) WHERE PRACOWNIK_WYSTAWIL_ID IS NULL;
ALTER TABLE RECEPTA ALTER COLUMN PRACOWNIK_WYSTAWIL_ID SET NOT NULL;

ALTER TABLE RECEPTA ADD ODDZIAL_NFZ VARCHAR(50);
UPDATE RECEPTA SET ODDZIAL_NFZ = 'NFZ_MAZOW' WHERE ODDZIAL_NFZ IS NULL;
ALTER TABLE RECEPTA ALTER COLUMN ODDZIAL_NFZ SET NOT NULL;

ALTER TABLE RECEPTA ADD UPRAWNIENIE VARCHAR(50);
UPDATE RECEPTA SET UPRAWNIENIE = 'X' WHERE UPRAWNIENIE IS NULL;
ALTER TABLE RECEPTA ALTER COLUMN UPRAWNIENIE SET NOT NULL;

ALTER TABLE RECEPTA ADD CHOROBY_PRZEWLEKLE VARCHAR(50);
UPDATE RECEPTA SET CHOROBY_PRZEWLEKLE = 'X' WHERE CHOROBY_PRZEWLEKLE IS NULL;
ALTER TABLE RECEPTA ALTER COLUMN CHOROBY_PRZEWLEKLE SET NOT NULL;

CREATE TABLE OSOBA_PARAMETR (
    ID IDENTITY NOT NULL,
    OSOBA_ID BIGINT(10) NOT NULL,
    TYP VARCHAR(50) NOT NULL,
    WARTOSC_S VARCHAR(50) NOT NULL,
    CONSTRAINT OSOBA_PARAMETR_pk PRIMARY KEY (ID)
);
ALTER TABLE OSOBA_PARAMETR ADD CONSTRAINT OSOBA_OSOBA_PARAMETR_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	
ALTER TABLE LEK_POSTAC ADD DOP_OBROT_POLSKA BOOLEAN;

ALTER TABLE RECEPTA ADD STATUS VARCHAR(50);
UPDATE RECEPTA SET STATUS = 'W_REALIZACJI' WHERE STATUS IS NULL;
ALTER TABLE RECEPTA ALTER COLUMN STATUS SET DEFAULT 'W_REALIZACJI';
ALTER TABLE RECEPTA ALTER COLUMN STATUS SET NOT NULL;

DROP VIEW REALIZACJA_UMOW_APTEKA IF EXISTS;
ALTER TABLE REALIZACJA_RECEPTA ALTER COLUMN KWOTA RENAME TO KWOTA_DOM;
ALTER TABLE REALIZACJA_RECEPTA ADD KWOTA_M DECIMAL(10,2);
UPDATE REALIZACJA_RECEPTA SET KWOTA_M = 0.0 WHERE KWOTA_M IS NULL;
ALTER TABLE REALIZACJA_RECEPTA ALTER COLUMN KWOTA_M SET NOT NULL;
CREATE VIEW REALIZACJA_UMOW_APTEKA AS
	SELECT ua.*, COALESCE(SUM(r.KWOTA_DOM), '0.00') as KWOTA_WYKORZYSTANA
	FROM UMOWA_APTEKA ua
		LEFT OUTER JOIN REALIZACJA_RECEPTA r ON ua.ID = r.UMOWA_ID
	GROUP BY ua.ID;

ALTER TABLE NIEOBECNOSC_INFORMACJA DROP CONSTRAINT EWIDENCJA_DPS_NIEOBECNOSC_INFORMACJA_fk IF EXISTS;
ALTER TABLE NIEOBECNOSC_INFORMACJA ADD EWIDENCJA_DPS_ID BIGINT(10);
UPDATE NIEOBECNOSC_INFORMACJA SET EWIDENCJA_DPS_ID = ID WHERE EWIDENCJA_DPS_ID IS NULL;
ALTER TABLE NIEOBECNOSC_INFORMACJA ALTER COLUMN EWIDENCJA_DPS_ID SET NOT NULL;
ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT EWIDENCJA_DPS_NIEOBECNOSC_INFORMACJA_fk
	FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


--//@UNDO
-- SQL to undo the change goes here.

