--// migracja poprawki raport z dyzuru.
-- Migration SQL that makes the change goes here.

CREATE TABLE INFORMACJA_DODATKOWA_ROZSZERZENIE (
    ID IDENTITY NOT NULL,
    INFORMACJA_DODATKOWA_ID BIGINT(7) NOT NULL,
    WARTOSC_TR BIGINT(10),
    TYP VARCHAR(50) NOT NULL,
    CONSTRAINT INFORMACJA_DODATKOWA_ROZSZERZENIE_pk PRIMARY KEY (ID)
);

ALTER TABLE INFORMACJA_DODATKOWA_ROZSZERZENIE ADD CONSTRAINT INFORMACJA_DODATKOWA_INFORMACJA_DODATKOWA_ROZSZERZENIE_fk
	FOREIGN KEY (INFORMACJA_DODATKOWA_ID)
	REFERENCES INFORMACJA_DODATKOWA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
ALTER TABLE INFORMACJA_DODATKOWA_ROZSZERZENIE ADD CONSTRAINT SLOWO_INFORMACJA_DODATKOWA_ROZSZERZENIE_WARTOSCTR_fk
	FOREIGN KEY (WARTOSC_TR)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- słownik typów raportów z dyżuru (niemodyfikowalny przez użytkowników)
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
INSERT INTO SLOWO (SLOWNIK_ID, KOLEJNOSC, WART_STRING, KOD) VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO'), 1, 'dzienny', '001');
INSERT INTO SLOWO (SLOWNIK_ID, KOLEJNOSC, WART_STRING, KOD) VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO'), 1, 'nocny', '002');

ALTER TABLE PORA_DNIA ADD GODZINA INTEGER;
-- ustawiam dla tych standardowych TT
UPDATE PORA_DNIA SET GODZINA = 8 WHERE SKROT = 'R';
UPDATE PORA_DNIA SET GODZINA = 13 WHERE SKROT = 'P';
UPDATE PORA_DNIA SET GODZINA = 19 WHERE SKROT = 'W';
UPDATE PORA_DNIA SET GODZINA = 23 WHERE SKROT = 'N';
-- dla pozostaych coś muszę ustawić
UPDATE PORA_DNIA SET GODZINA = 9 WHERE GODZINA IS NULL;
ALTER TABLE PORA_DNIA ALTER COLUMN GODZINA SET NOT NULL;

-- godziny rozpoczęcia dyżurów pielęgniarskich
INSERT INTO PARAMETR_SYSTEMOWY(TYP, DATA_OD, DATA_DO, WARTOSC_I, UKRYTY) VALUES ('GODZINA_DYZUR_DZIENNY', NULL, NULL, 7, false);
INSERT INTO PARAMETR_SYSTEMOWY(TYP, DATA_OD, DATA_DO, WARTOSC_I, UKRYTY) VALUES ('GODZINA_DYZUR_NOCNY', NULL, NULL, 19, false);

-- poprawki dla monitorowania osób
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 4
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'MONITOROWANIE_OSOB' LIMIT 1)
	AND NAZWA = 'obiekt monitorowania';
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 5
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'MONITOROWANIE_OSOB' LIMIT 1)
	AND NAZWA = 'uwagi';
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'MONITOROWANIE_OSOB' LIMIT 1),
	null, 3, 'dotyczy dyżurów piel.', 'SLOWNIK_MULTI', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
	-- puste wpisy dotyczące przynależności do raportów (tak by się wszystko poprawnie wyświetlało)
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='MONITOROWANIE_OSOB'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = 'dotyczy dyżurów piel.';


-- poprawki dla odwiedzin mieszkańca
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 3
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ODWIEDZINY' LIMIT 1)
	AND NAZWA = 'opis';
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ODWIEDZINY' LIMIT 1),
	null, 2, 'godzina', 'LICZBA_I', TRUE, null);
-- puste wpisy dotyczące przynależności do raportów (tak by się wszystko poprawnie wyświetlało)
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='ODWIEDZINY'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = 'godzina';
	 		
-- poprawki dla pomiaru glikemii
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 3
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_GLIKEMII' LIMIT 1)
	AND NAZWA = 'wynik';
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_GLIKEMII' LIMIT 1),
	null, 2, STRINGDECODE('dotyczy dy\u017Curu piel.'), 'SLOWNIK', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
-- puste wpisy dotyczące przynależności do raportów (tak by się wszystko poprawnie wyświetlało)
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='POMIAR_GLIKEMII'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.');
	 		
-- poprawki dla pomiaru alkomatem
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 3
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_ALKOMATEM' LIMIT 1)
	AND NAZWA = 'wynik';
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 4
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_ALKOMATEM' LIMIT 1)
	AND NAZWA = 'uwagi';
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_ALKOMATEM' LIMIT 1),
	null, 2, STRINGDECODE('dotyczy dy\u017Curu piel.'), 'SLOWNIK', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
-- puste wpisy dotyczące przynależności do raportów (tak by się wszystko poprawnie wyświetlało)
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='POMIAR_ALKOMATEM'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.');
	 		

-- poprawki dla pobrania krwi do badań
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POBRANIE_KRWI' LIMIT 1),
	null, 2, STRINGDECODE('dotyczy dy\u017Curu piel.'), 'SLOWNIK', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
-- puste wpisy dotyczące przynależności do raportów (tak by się wszystko poprawnie wyświetlało)
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='POBRANIE_KRWI'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.');

-- porpawki dla pomiaru czasu pracy lampy UV
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 3
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1)
	AND NAZWA = 'minuty';
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 4
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1)
	AND NAZWA = 'lampa (ozn.)';
UPDATE INFORMACJA_DODATKOWA_POLE
	SET KOLEJNOSC = 5
WHERE INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1)
	AND NAZWA = 'opis';
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1),
	null, 2, STRINGDECODE('dotyczy dy\u017Curu piel.'), 'SLOWNIK', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
-- puste wpisy dotyczące przynależności do raportów (tak by się wszystko poprawnie wyświetlało)
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='CZAS_PRACY_LAMPY_UV'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.');
	 		
-- poprawki dla hospitalizacji mieszkańców
ALTER TABLE NIEOBECNOSC_INFORMACJA ADD DYZUR_POWROT_ID BIGINT(10);
ALTER TABLE NIEOBECNOSC_INFORMACJA ADD DYZUR_WYJAZD_ID BIGINT(10);
ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT SLOWO_NIEOBECNOSC_INFORMACJA_DYZUR_WYJAZD_fk
	FOREIGN KEY (DYZUR_WYJAZD_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT SLOWO_NIEOBECNOSC_INFORMACJA_DYZUR_POWROT_fk
	FOREIGN KEY (DYZUR_POWROT_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- poprawki dotyczące ewidencji zgonu osoby
ALTER TABLE EWIDENCJA_DPS ADD GODZINA INTEGER;

-- poprawki dotyczące magazynu leków doraźnych
ALTER TABLE MAGAZYN_OPERACJA ADD GODZINA INTEGER;


--//@UNDO
-- SQL to undo the change goes here.

