--// migracja srodki pomocnicze.
-- Migration SQL that makes the change goes here.

-- poprawki zadań czasowych
DELETE FROM QRTZ_JOB_LISTENERS WHERE JOB_NAME = 'MeldunekCzasowyMieszkaniec' AND JOB_GROUP = 'PRZYPOMINACZE';
DELETE FROM QRTZ_JOB_DETAILS WHERE JOB_NAME = 'MeldunekCzasowyMieszkaniec' AND JOB_GROUP = 'PRZYPOMINACZE';
INSERT INTO QRTZ_JOB_DETAILS(JOB_NAME, JOB_GROUP, DESCRIPTION,
    JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
  VALUES('MeldunekCzasowyMieszkaniec', 'PRZYPOMINACZE', 'Aktualizuje dane nt. zbliżających się terminów końca meldunków czasowych dla mieszkańców',
    'pl.topteam.dps.timeTask.przypominacze.DowodOsobistyWaznoscMieszkaniec', 'TRUE', 'FALSE', 'FALSE', 'FALSE', '', true);
INSERT INTO QRTZ_JOB_LISTENERS(JOB_NAME, JOB_GROUP, JOB_LISTENER)
  VALUES ('MeldunekCzasowyMieszkaniec', 'PRZYPOMINACZE', 'pl.topteam.dps.timeTask.listener.TemporaryTableListener');

DELETE FROM QRTZ_JOB_LISTENERS WHERE JOB_NAME = 'IPWMWaznoscMieszkaniec' AND JOB_GROUP = 'PRZYPOMINACZE';
DELETE FROM QRTZ_JOB_DETAILS WHERE JOB_NAME = 'IPWMWaznoscMieszkaniec' AND JOB_GROUP = 'PRZYPOMINACZE';
INSERT INTO QRTZ_JOB_DETAILS(JOB_NAME, JOB_GROUP, DESCRIPTION,
    JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
  VALUES('IPWMWaznoscMieszkaniec', 'PRZYPOMINACZE', 'Aktualizuje dane nt. zbliżających się terminów końca IPWM',
    'pl.topteam.dps.timeTask.przypominacze.IPWMWaznoscMieszkaniec', 'TRUE', 'FALSE', 'FALSE', 'FALSE', '', true);

INSERT INTO QRTZ_JOB_LISTENERS(JOB_NAME, JOB_GROUP, JOB_LISTENER)
  VALUES ('IPWMWaznoscMieszkaniec', 'PRZYPOMINACZE', 'pl.topteam.dps.timeTask.listener.TemporaryTableListener');


CREATE TABLE ZLECENIE_WYROB_MEDYCZNY (
                ID IDENTITY NOT NULL,
                ADRES_OSOBY_ID BIGINT(10) NOT NULL,
                OSOBA_ID BIGINT(10) NOT NULL,
                ZLECENIE_NADRZEDNE_ID BIGINT(10),
                DATA_WYSTAWIENIA DATE,
                DYSFUNKCJA VARCHAR(50),
                ICD10 VARCHAR(3),
                NAZWA_DOKUMENTU VARCHAR(100),
                NR_DOKUMENTU VARCHAR(50),
                NR_EWIDENCYJNY VARCHAR(50),
                RODZAJ VARCHAR(50) NOT NULL,
                ZAOPATRZENIE_PO_SP VARCHAR(50),
                CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_pk PRIMARY KEY (ID)
);

CREATE TABLE ZLECENIE_SOCZEWKA (
                ZLECENIE_ID BIGINT(10) NOT NULL,
                RODZAJ VARCHAR(50) NOT NULL,
                OL_SFERA DECIMAL(10,2),
                OL_CYLINDER DECIMAL(10,2),
                OL_OS DECIMAL(10,2),
                OL_PRYZMA DECIMAL(10,2),
                OP_SFERA DECIMAL(10,2),
                OP_CYLINDER DECIMAL(10,2),
                OP_OS DECIMAL(10,2),
                OP_PRYZMA DECIMAL(10,2),
                ODL_ZRENIC INTEGER NOT NULL,
                CONSTRAINT ZLECENIE_SOCZEWKA_pk PRIMARY KEY (ZLECENIE_ID)
);

CREATE TABLE ZLECENIE_UPRAWNIENIA (
                ZLECENIE_ID BIGINT(10) NOT NULL,
                KOD_TYTULU_UPR VARCHAR(10) NOT NULL,
                KOD_TYTULU_UPR_DOD VARCHAR(10),
                DATA_OD DATE NOT NULL,
                DATA_DO DATE NOT NULL,
                KOD VARCHAR(8) NOT NULL,
                KOD_ZAM_1 VARCHAR(8),
                KOD_ZAM_2 VARCHAR(8),
                KOD_ZAM_3 VARCHAR(8),
                CONSTRAINT ZLECENIE_UPRAWNIENIA_pk PRIMARY KEY (ZLECENIE_ID)
);

CREATE TABLE ZLECENIE_WYDANIE_WYROB (
                ZLECENIE_ID BIGINT(10) NOT NULL,
                DANE_WM VARCHAR(300) NOT NULL,
                DATA_ODBIORU DATE NOT NULL,
                KWOTA_NFZ DECIMAL(10,2) NOT NULL,
                KWOTA_SWIADCZENIOBIORCA DECIMAL(10,2) NOT NULL,
                NR_UMOWY VARCHAR(50) NOT NULL,
                LICZBA_SZTUK INTEGER NOT NULL,
                CONSTRAINT ZLECENIE_WYDANIE_WYROB_pk PRIMARY KEY (ZLECENIE_ID)
);

CREATE TABLE ZLECENIE_WYDANIA_WYROB_MIESIAC (
                MIESIAC INTEGER NOT NULL,
                ZLECENIE_ID BIGINT(10) NOT NULL,
                CONSTRAINT ZLECENIE_WYDANIA_WYROB_MIESIAC_pk PRIMARY KEY (MIESIAC, ZLECENIE_ID)
);

CREATE TABLE ZLECENIE_PRZEDMIOT (
                ZLECENIE_ID BIGINT(10) NOT NULL,
                INFO_DOBOR LONGVARCHAR,
                KOD VARCHAR(8) NOT NULL,
                LICZBA_SZTUK INTEGER NOT NULL,
                NAZWA VARCHAR(250) NOT NULL,
                CONSTRAINT ZLECENIE_PRZEDMIOT_pk PRIMARY KEY (ZLECENIE_ID)
);

ALTER TABLE ZLECENIE_WYROB_MEDYCZNY ADD CONSTRAINT ADRES_ZLECENIE_WYROB_MEDYCZNY_fk
FOREIGN KEY (ADRES_OSOBY_ID)
REFERENCES ADRES (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ZLECENIE_WYROB_MEDYCZNY ADD CONSTRAINT OSOBA_ZLECENIE_WYROB_MEDYCZNY_fk
FOREIGN KEY (OSOBA_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ZLECENIE_PRZEDMIOT ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_PRZEDMIOT_fk
FOREIGN KEY (ZLECENIE_ID)
REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZLECENIE_WYDANIA_WYROB_MIESIAC ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_MIESIAC_DOTYCZY_fk
FOREIGN KEY (ZLECENIE_ID)
REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZLECENIE_WYDANIE_WYROB ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_WYDANIA_fk
FOREIGN KEY (ZLECENIE_ID)
REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZLECENIE_UPRAWNIENIA ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_UPRAWNIENIA_fk
FOREIGN KEY (ZLECENIE_ID)
REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZLECENIE_SOCZEWKA ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_SOCZEWKI_fk
FOREIGN KEY (ZLECENIE_ID)
REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZLECENIE_WYROB_MEDYCZNY ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_WYROB_MEDYCZNY_fk
FOREIGN KEY (ZLECENIE_NADRZEDNE_ID)
REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;


--//@UNDO
-- SQL to undo the change goes here.

