--// migracja leki niezrealizowane.
-- Migration SQL that makes the change goes here.

ALTER TABLE LEK_REALIZACJA DROP CONSTRAINT REALIZACJA_RECEPTA_LEK_REALIZACJA_fk;
ALTER TABLE LEK_REALIZACJA DROP CONSTRAINT LEK_POSTAC_LEK_REALIZACJA_fk;
ALTER TABLE LEK_REALIZACJA DROP CONSTRAINT LEK_REALIZACJA_pk;
ALTER TABLE LEK_REALIZACJA RENAME TO TMP_LEK_REALIZACJA;

CREATE TABLE LEK_REALIZACJA (
    REALIZACJA_RECEPTA_ID BIGINT(10) NOT NULL,
    KOD_BAZYL BIGINT(10) NOT NULL,
    NIEZREALIZOWANY BOOLEAN DEFAULT FALSE NOT NULL,
    LICZBA_OPAKOWAN INTEGER NOT NULL,
    DATA DATE,
    CONSTRAINT LEK_REALIZACJA_pk PRIMARY KEY (REALIZACJA_RECEPTA_ID, KOD_BAZYL, NIEZREALIZOWANY)
);
ALTER TABLE LEK_REALIZACJA ADD CONSTRAINT REALIZACJA_RECEPTA_LEK_REALIZACJA_fk
	FOREIGN KEY (REALIZACJA_RECEPTA_ID)
	REFERENCES REALIZACJA_RECEPTA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
ALTER TABLE LEK_REALIZACJA ADD CONSTRAINT LEK_POSTAC_LEK_REALIZACJA_fk
	FOREIGN KEY (KOD_BAZYL)
	REFERENCES LEK_POSTAC (KOD_BAZYL)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

INSERT INTO LEK_REALIZACJA (REALIZACJA_RECEPTA_ID, KOD_BAZYL, NIEZREALIZOWANY, LICZBA_OPAKOWAN, DATA)
	SELECT
		REALIZACJA_RECEPTA_ID, KOD_BAZYL,
		(CASE WHEN NIEZREALIZOWANY IS NULL THEN FALSE ELSE NIEZREALIZOWANY END) AS NIEZREALIZOWANY, LICZBA_OPAKOWAN, DATA
	FROM TMP_LEK_REALIZACJA;
	
DROP TABLE TMP_LEK_REALIZACJA;


--//@UNDO
-- SQL to undo the change goes here.

