--// migracja godziny dyzur pielegniarski.
-- Migration SQL that makes the change goes here.

-- poprawki w słownikach
INSERT INTO SLOWO (SLOWNIK_ID, KOD, WART_STRING) VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_SWIADCZENIA' LIMIT 1), '670', 'Renta socjalna');
INSERT INTO SLOWO (SLOWNIK_ID, KOD, WART_STRING) VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_SWIADCZENIA' LIMIT 1), '671', 'Renta rodzinna');
INSERT INTO SLOWO (SLOWNIK_ID, KOD, WART_STRING) VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_SWIADCZENIA' LIMIT 1), '672', 'Renta rodzina + socjalna');

-- dla wszystkich pracowników ustawiam domyślnie, że nie pracują na dyżurze pielęgniarskim
INSERT INTO PRACOWNIK_PARAMETR(PRACOWNIK_ID, TYP, WARTOSC_S)
	SELECT p.ID, 'DYZUR_PIELEGNIARSKI' as TYP, 'NIE_DOTYCZY' as WARTOSC_S
	FROM PRACOWNIK p;
	
 -- automatyczne ustawienia pracownika dotyczące dyżuru pielęgniarskiego (co godzinę; ukryte przed wszelkimi zmianami triggerów)
INSERT INTO QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION,
		JOB_CLASS_NAME, IS_DURABLE, IS_UPDATE_DATA, IS_NONCONCURRENT, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
	VALUES('QuartzServer', 'ZmianaDyzuru', 'USTAWIENIOWE', STRINGDECODE('Zmienia domy\u015Blne ustawienie dotycz\u0105ce rodzaju dy\u017Curu'),
		'pl.topteam.dps.timeTask.ustawienia.RodzajDyzuruPielegniarskiego', 'FALSE', 'FALSE', 'FALSE', 'FALSE', '', true);

INSERT INTO QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP,
		DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, MISFIRE_INSTR)
	VALUES('QuartzServer', 'WyzwalaczZmianaDyzuru', 'USTAWIENIOWE', 'ZmianaDyzuru', 'USTAWIENIOWE',
		STRINGDECODE('Zmienia domy\u015Blne ustawienie dotycz\u0105ce rodzaju dy\u017Curu'), 1276514580000, 1276514570000, 5, 'ACQUIRED', 'CRON', 1276512961000, 0, 1);

INSERT INTO QRTZ_CRON_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)
	VALUES('QuartzServer', 'WyzwalaczZmianaDyzuru', 'USTAWIENIOWE', '0 0 * * * ? *', 'Europe/Belgrade');

-- zmiana w pomiarach ciśnienia tętniczego
	-- na podstawie godziny określenie typu dyżuru
INSERT INTO POLE_SLOWNIK(ID, WARTOSC)
	SELECT idpw.ID,
		(
			CASE WHEN pli.WARTOSC < (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_DZIENNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))))
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '002')
				WHEN pli.WARTOSC > (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_NOCNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))))
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '003')
				ELSE
					(SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '001')
				END
		) as WARTOSC
	FROM INFORMACJA_DODATKOWA_POLE_WPIS idpw
		JOIN INFORMACJA_DODATKOWA_POLE idp ON idpw.POLE_ID = idp.ID
			AND idp.NAZWA = 'godzina'
		JOIN INFORMACJA_DODATKOWA id ON idp.INFORMACJA_DODATKOWA_ID = id.ID
			AND id.TYP = 'POMIAR_CISNIENIA'
		JOIN POLE_LICZBA_I pli ON idpw.ID = pli.ID
;
	-- usuwanie wszystkich wpisów godzin
DELETE FROM POLE_LICZBA_I pi
WHERE ID IN (
	SELECT idpw.ID
	FROM INFORMACJA_DODATKOWA_POLE_WPIS idpw
		JOIN INFORMACJA_DODATKOWA_POLE idp ON idpw.POLE_ID = idp.ID
			AND idp.NAZWA = 'godzina'
		JOIN INFORMACJA_DODATKOWA id ON idp.INFORMACJA_DODATKOWA_ID = id.ID
			AND id.TYP = 'POMIAR_CISNIENIA'
);
-- zmiana w definicji pomiarów ciśnienia
	-- usuwanie pola godziny
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.'),
		NAZWA_SLOWNIKA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO',
		WYMAGANE = FALSE,
		TYP = 'SLOWNIK'
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_CISNIENIA' LIMIT 1)
		AND
		KOLEJNOSC = 2;

-- zmiany w definicji interwencji pogotowia ratunkowego
	-- opis jako 4 w kolejności
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		KOLEJNOSC = 4,
		WYMAGANE = FALSE
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_POG_RAT' LIMIT 1)
		AND
		KOLEJNOSC = 3;
	-- godzina jako nieobowiązkowe
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		KOLEJNOSC = 3,
		WYMAGANE = FALSE
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_POG_RAT' LIMIT 1)
		AND
		KOLEJNOSC = 2;
	-- wstawianie nowego pola świadczącego o dyżurze
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_POG_RAT' LIMIT 1),
	null, 2, STRINGDECODE('dotyczy dy\u017Curu piel.'), 'SLOWNIK', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
	
-- zmiana w interwencji pogotowia ratunkowego
	-- wstawianie wpisu dot. pola dyżuru
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='INTERWENCJA_POG_RAT'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.');
	-- wstawianie informacji nt. rodzaju dyżuru
INSERT INTO POLE_SLOWNIK(ID, WARTOSC)
	SELECT (
			SELECT idpwrdz.ID
			FROM INFORMACJA_DODATKOWA_POLE_WPIS idpwrdz
				JOIN INFORMACJA_DODATKOWA_POLE idprdz ON idpwrdz.POLE_ID = idprdz.ID
					AND idpwrdz.INFORMACJA_WPIS_ID = idpw.INFORMACJA_WPIS_ID
					AND idprdz.INFORMACJA_DODATKOWA_ID = idp.INFORMACJA_DODATKOWA_ID
					AND idprdz.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.')
		) as ID,
		(
			CASE WHEN pli.WARTOSC < (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_DZIENNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))))
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '002')
				WHEN pli.WARTOSC > (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_NOCNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))))
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '003')
				ELSE
					(SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '001')
				END
		) as WARTOSC
	FROM INFORMACJA_DODATKOWA_POLE_WPIS idpw
		JOIN INFORMACJA_DODATKOWA_POLE idp ON idpw.POLE_ID = idp.ID
			AND idp.NAZWA = 'godzina'
		JOIN INFORMACJA_DODATKOWA id ON idp.INFORMACJA_DODATKOWA_ID = id.ID
			AND id.TYP = 'INTERWENCJA_POG_RAT'
		JOIN POLE_LICZBA_I pli ON idpw.ID = pli.ID
;

-- zmiany w definicji odwiedzin mieszkańców
	-- opis jako 4 w kolejności
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		KOLEJNOSC = 4,
		WYMAGANE = FALSE
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ODWIEDZINY' LIMIT 1)
		AND
		KOLEJNOSC = 3;
	-- godzina jako nieobowiązkowe
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		KOLEJNOSC = 3,
		WYMAGANE = FALSE
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ODWIEDZINY' LIMIT 1)
		AND
		KOLEJNOSC = 2;
	-- wstawianie nowego pola świadczącego o dyżurze
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ODWIEDZINY' LIMIT 1),
	null, 2, STRINGDECODE('dotyczy dy\u017Curu piel.'), 'SLOWNIK', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');
-- zmiana w odwiedzinach
	-- wstawianie wpisu dot. pola dyżuru
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='ODWIEDZINY'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.');
	-- wstawianie informacji nt. rodzaju dyżuru
INSERT INTO POLE_SLOWNIK(ID, WARTOSC)
	SELECT (
			SELECT idpwrdz.ID
			FROM INFORMACJA_DODATKOWA_POLE_WPIS idpwrdz
				JOIN INFORMACJA_DODATKOWA_POLE idprdz ON idpwrdz.POLE_ID = idprdz.ID
					AND idpwrdz.INFORMACJA_WPIS_ID = idpw.INFORMACJA_WPIS_ID
					AND idprdz.INFORMACJA_DODATKOWA_ID = idp.INFORMACJA_DODATKOWA_ID
					AND idprdz.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.')
		) as ID,
		(
			CASE WHEN pli.WARTOSC < (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_DZIENNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))) LIMIT 1)
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '002' LIMIT 1)
				WHEN pli.WARTOSC > (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_NOCNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))) LIMIT 1)
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '003' LIMIT 1)
				ELSE
					(SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '001' LIMIT 1)
				END
		) as WARTOSC
	FROM INFORMACJA_DODATKOWA_POLE_WPIS idpw
		JOIN INFORMACJA_DODATKOWA_POLE idp ON idpw.POLE_ID = idp.ID
			AND idp.NAZWA = 'godzina'
		JOIN INFORMACJA_DODATKOWA id ON idp.INFORMACJA_DODATKOWA_ID = id.ID
			AND id.TYP = 'ODWIEDZINY'
		JOIN POLE_LICZBA_I pli ON idpw.ID = pli.ID
;

-- poprawki w magazynie leków doraźnych
ALTER TABLE MAGAZYN_OPERACJA ADD SLOWO_ID BIGINT(10);
ALTER TABLE MAGAZYN_OPERACJA ADD CONSTRAINT SLOWO_MAGAZYN_OPERACJA_fk
	FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE LEK_REALIZACJA ADD SLOWO_ID BIGINT(10);
ALTER TABLE LEK_REALIZACJA ADD CONSTRAINT SLOWO_LEK_REALIZACJA_fk
	FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
UPDATE MAGAZYN_OPERACJA mo SET
	mo.SLOWO_ID = (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '002' LIMIT 1)
WHERE
	mo.GODZINA < (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_DZIENNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))) LIMIT 1);
UPDATE MAGAZYN_OPERACJA mo SET
	mo.SLOWO_ID = (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '003')
WHERE
	mo.GODZINA > (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_NOCNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))) LIMIT 1);
UPDATE MAGAZYN_OPERACJA mo SET
	mo.SLOWO_ID = (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '001' LIMIT 1)
WHERE
	mo.GODZINA IS NOT NULL
	AND
	mo.SLOWO_ID IS NULL;
ALTER TABLE MAGAZYN_OPERACJA DROP COLUMN GODZINA;


--//@UNDO
-- SQL to undo the change goes here.

