--// migracja konta bankowe.
-- Migration SQL that makes the change goes here.

-- konto bankowe
CREATE TABLE KONTO_BANKOWE (
    ID IDENTITY NOT NULL,
    IBAN VARCHAR(26) NOT NULL,
    CONSTRAINT KONTO_BANKOWE_pk PRIMARY KEY (ID)
);

-- konto jednostki
CREATE TABLE DPS_JEDNOSTKA_KONTO_BANKOWE (
    DPS_JEDNOSTKA_ID BIGINT(7) NOT NULL,
    KONTO_ID BIGINT(10) NOT NULL,
    CONSTRAINT DPS_JEDNOSTKA_KONTO_BANKOWE_pk PRIMARY KEY (DPS_JEDNOSTKA_ID, KONTO_ID)
);

ALTER TABLE DPS_JEDNOSTKA_KONTO_BANKOWE ADD CONSTRAINT KONTO_BANKOWE_DPS_JEDNOSTKA_KONTO_BANKOWE_fk
	FOREIGN KEY (KONTO_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE DPS_JEDNOSTKA_KONTO_BANKOWE ADD CONSTRAINT DPS_JEDNOSTKA_DPS_JEDNOSTKA_KONTO_BANKOWE_fk
	FOREIGN KEY (DPS_JEDNOSTKA_ID)
	REFERENCES DPS_JEDNOSTKA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


-- konto instytucji
CREATE TABLE INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE (
    INSTYTUCJA_ID BIGINT(10) NOT NULL,
    KONTO_ID BIGINT(10) NOT NULL,
    CONSTRAINT INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE_pk PRIMARY KEY (INSTYTUCJA_ID, KONTO_ID)
);

ALTER TABLE INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE ADD CONSTRAINT KONTO_BANKOWE_INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE_fk
	FOREIGN KEY (KONTO_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE_fk
	FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


-- konto osoby
CREATE TABLE OSOBA_KONTO_BANKOWE (
    KONTO_ID BIGINT(10) NOT NULL,
    OSOBA_ID BIGINT(10) NOT NULL,
    CONSTRAINT OSOBA_KONTO_BANKOWE_pk PRIMARY KEY (KONTO_ID, OSOBA_ID)
);

ALTER TABLE OSOBA_KONTO_BANKOWE ADD CONSTRAINT KONTO_BANKOWE_OSOBA_KONTO_BANKOWE_fk
	FOREIGN KEY (KONTO_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE OSOBA_KONTO_BANKOWE ADD CONSTRAINT OSOBA_OSOBA_KONTO_BANKOWE_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- indeks 
CREATE UNIQUE INDEX KB_IBAN_KONTA
	ON KONTO_BANKOWE(IBAN);
	
	
--//@UNDO
-- SQL to undo the change goes here.

