--// migracja wyrownujaca.
-- Migration SQL that makes the change goes here.

ALTER TABLE PRZELEW_DRUK DROP CONSTRAINT IF EXISTS MIESZKANIEC_PRZELEW_DRUK_fk;
ALTER TABLE PRZELEW_DRUK DROP CONSTRAINT IF EXISTS OSOBA_PRZELEW_DRUK_fk;
ALTER TABLE PRZELEW_DRUK DROP CONSTRAINT IF EXISTS INSTYTUCJA_DOPLACAJACA_PRZELEW_DRUK_fk;
ALTER TABLE PRZELEW_DRUK DROP PRIMARY KEY;

ALTER TABLE PRZELEW_DRUK RENAME TO PRZELEW_DRUK_TMP;

CREATE TABLE PRZELEW_DRUK (
    ID IDENTITY NOT NULL,
    INSTYTUCJA_ID BIGINT(10),
    MIESZKANIEC_ID BIGINT(10) NOT NULL,
    OSOBA_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    MIESIAC INTEGER NOT NULL,
    ROK INTEGER NOT NULL,
    TYTULEM VARCHAR(100) NOT NULL,
    DATA_GENEROWANIA TIMESTAMP,
    CONSTRAINT PRZELEW_DRUK_pk PRIMARY KEY (ID)
);

ALTER TABLE PRZELEW_DRUK ADD CONSTRAINT MIESZKANIEC_PRZELEW_DRUK_fk
	FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE PRZELEW_DRUK ADD CONSTRAINT OSOBA_PRZELEW_DRUK_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
ALTER TABLE PRZELEW_DRUK ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_PRZELEW_DRUK_fk
	FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
INSERT INTO PRZELEW_DRUK(INSTYTUCJA_ID, MIESZKANIEC_ID, OSOBA_ID, KWOTA, MIESIAC, ROK, TYTULEM)
	SELECT tmp.INSTYTUCJA_ID, tmp.MIESZKANIEC_ID, tmp.OSOBA_ID, tmp.KWOTA, tmp.MIESIAC, tmp.ROK, tmp.TYTULEM
	FROM PRZELEW_DRUK_TMP tmp;
	
DROP TABLE PRZELEW_DRUK_TMP;
	
--//@UNDO
-- SQL to undo the change goes here.

