--// migracja rozliczanie odplatnosci 1 nowe tabele.
-- Migration SQL that makes the change goes here.


-- USUWANIE ZBĘDNYCH KLUCZY
ALTER TABLE PRZELEW_DRUK DROP CONSTRAINT IF EXISTS INSTYTUCJA_DOPLACAJACA_PRZELEW_DRUK_fk;
ALTER TABLE PRZELEW_DRUK DROP CONSTRAINT IF EXISTS MIESZKANIEC_PRZELEW_DRUK_fk;
ALTER TABLE PRZELEW_DRUK DROP CONSTRAINT IF EXISTS OSOBA_PRZELEW_DRUK_fk;

ALTER TABLE ODPIS_ZWROT DROP CONSTRAINT IF EXISTS OSOBA_ODPIS_ZWROT_fk;
ALTER TABLE ODPIS_ZWROT DROP CONSTRAINT IF EXISTS MIESZKANIEC_ODPIS_ZWROT_fk;
ALTER TABLE ODPIS_ZWROT DROP CONSTRAINT IF EXISTS INSTYTUCJA_DOPLACAJACA_ODPIS_ZWROT_fk;

ALTER TABLE PLATNOSC DROP CONSTRAINT IF EXISTS OSOBA_PLATNOSC_fk;

ALTER TABLE PLATNOSC_PODSTAWA DROP CONSTRAINT IF EXISTS PLATNOSC_PLATNOSC_PODSTAWA_fk;

ALTER TABLE PLATNOSC_SKLADNIK DROP CONSTRAINT IF EXISTS PLATNOSC_PLATNOSC_OSOBA_fk;
ALTER TABLE PLATNOSC_SKLADNIK DROP CONSTRAINT IF EXISTS OSOBA_PLATNOSC_OSOBA_fk;
ALTER TABLE PLATNOSC_SKLADNIK DROP CONSTRAINT IF EXISTS INSTYTUCJA_DOPLACAJACA_PLATNOSC_SKLADNIK_fk;

ALTER TABLE WPLATA DROP CONSTRAINT IF EXISTS MIESZKANIEC_WPLATA_fk;

ALTER TABLE WPLATA_SZCZEGOLY DROP CONSTRAINT IF EXISTS FAKTURA_WPLATA_SZCZEGOLY_fk;
ALTER TABLE WPLATA_SZCZEGOLY DROP CONSTRAINT IF EXISTS WPLATA_WPLATA_SZCZEGOLY_fk;
ALTER TABLE WPLATA_SZCZEGOLY DROP PRIMARY KEY;


-- ZADLUZENIE
CREATE TABLE ZADLUZENIE (
    ID IDENTITY NOT NULL,
    OSOBA_ID BIGINT(10) NOT NULL,
    MIESIAC INTEGER NOT NULL,
    ROK INTEGER NOT NULL,
    CONSTRAINT ZADLUZENIE_pk PRIMARY KEY (ID)
);

CREATE TABLE ZADLUZENIE_POZYCJA (
    ID IDENTITY NOT NULL,
    INSTYTUCJA_ID BIGINT(10),
    OSOBA_ID BIGINT(10),
    ZADLUZENIE_ID BIGINT(10) NOT NULL,
    AKTUALNOSC VARCHAR(50) NOT NULL,
    KWOTA DECIMAL(10,2) NOT NULL,
    RODZAJ VARCHAR(50) NOT NULL,
    STATUS VARCHAR(50) NOT NULL,
    CONSTRAINT ZADLUZENIE_POZYCJA_pk PRIMARY KEY (ID)
);

ALTER TABLE ZADLUZENIE_POZYCJA ADD CONSTRAINT ZADLUZENIE_OSOBA_ZADLUZENIE_fk
	FOREIGN KEY (ZADLUZENIE_ID)
	REFERENCES ZADLUZENIE (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	
ALTER TABLE ZADLUZENIE ADD CONSTRAINT OSOBA_ZADLUZENIE_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZADLUZENIE_POZYCJA ADD CONSTRAINT OSOBA_OSOBA_ZADLUZENIE_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
ALTER TABLE ZADLUZENIE_POZYCJA ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_OSOBA_ZADLUZENIE_fk
	FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


-- NALICZENIA
CREATE TABLE NALICZENIE_POBYT (
    ID IDENTITY NOT NULL,
    ZADLUZENIE_POZYCJA_ID BIGINT(10) NOT NULL,
    DATA_OBLICZENIA DATE NOT NULL,
    KWOTA DECIMAL(10,2) NOT NULL,
    CONSTRAINT NALICZENIE_POBYT_pk PRIMARY KEY (ID)
);

ALTER TABLE NALICZENIE_POBYT ADD CONSTRAINT ZADLUZENIE_POZYCJA_NALICZENIE_POBYT_fk
	FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	
CREATE TABLE NALICZENIE_PODSTAWA (
    NALICZENIE_ID BIGINT(10) NOT NULL,
    ODPLATNOSC_ID BIGINT(10) NOT NULL,
    CONSTRAINT NALICZENIE_PODSTAWA_pk PRIMARY KEY (NALICZENIE_ID, ODPLATNOSC_ID)
);

ALTER TABLE NALICZENIE_PODSTAWA ADD CONSTRAINT NALICZENIE_POBYT_NALICZENIE_PODSTAWA_fk
	FOREIGN KEY (NALICZENIE_ID)
	REFERENCES NALICZENIE_POBYT (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	
ALTER TABLE NALICZENIE_PODSTAWA ADD CONSTRAINT ODPLATNOSC_NALICZENIE_PODSTAWA_fk
	FOREIGN KEY (ODPLATNOSC_ID)
	REFERENCES ODPLATNOSC (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


-- WPŁATY
ALTER TABLE WPLATA_SZCZEGOLY RENAME TO OLD_WPLATA_SZCZEGOLY;

CREATE TABLE WPLATA_SKLADNIK (
    WPLATA_ID BIGINT(10) NOT NULL,
    ZADLUZENIE_POZYCJA_ID BIGINT(10) NOT NULL,
    FAKTURA_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    CONSTRAINT WPLATA_SKLADNIK_pk PRIMARY KEY (WPLATA_ID, ZADLUZENIE_POZYCJA_ID)
);

ALTER TABLE WPLATA_SKLADNIK ADD CONSTRAINT FAKTURA_WPLATA_SKLADNIK_fk
	FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE WPLATA_SKLADNIK ADD CONSTRAINT ZADLUZENIE_POZYCJA_WPLATA_SKLADNIK_fk
	FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE WPLATA_SKLADNIK ADD CONSTRAINT WPLATA_WPLATA_SKLADNIK_fk
	FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	
-- PRZELEW DRUK
UPDATE PRZELEW_DRUK SET DATA_GENEROWANIA = NOW() WHERE DATA_GENEROWANIA IS NULL;
ALTER TABLE PRZELEW_DRUK ALTER COLUMN DATA_GENEROWANIA SET NOT NULL;

ALTER TABLE PRZELEW_DRUK ADD ZADLUZENIE_POZYCJA_ID BIGINT(10);
ALTER TABLE PRZELEW_DRUK ADD CONSTRAINT ZADLUZENIE_POZYCJA_PRZELEW_DRUK_fk
	FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- ODPIS ZWROT
ALTER TABLE ODPIS_ZWROT ADD ZADLUZENIE_POZYCJA_ID BIGINT(10);
ALTER TABLE ODPIS_ZWROT ADD CONSTRAINT ZADLUZENIE_POZYCJA_ODPIS_ZWROT_fk
	FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	


--//@UNDO
-- SQL to undo the change goes here.

