--// migracja rozliczanie odplatnosci 2 dane zadluzen.
-- Migration SQL that makes the change goes here.

-- ZADŁUŻENIE
INSERT INTO ZADLUZENIE(
		OSOBA_ID,
		ROK,
		MIESIAC)
	SELECT
		p.OSOBA_ID,
		p.ROK, p.MIESIAC
	FROM PLATNOSC p
	UNION
	SELECT
		w.MIESZKANIEC_ID as OSOBA_ID,
		ows.ROK, ows.MIESIAC
	FROM WPLATA w
		JOIN OLD_WPLATA_SZCZEGOLY ows ON w.ID = ows.WPLATA_ID
	UNION
	SELECT
		oz.MIESZKANIEC_ID as OSOBA_ID,
		oz.ROK, oz.MIESIAC
	FROM ODPIS_ZWROT oz
	UNION
	SELECT
		pd.MIESZKANIEC_ID as OSOBA_ID,
		pd.ROK, pd.MIESIAC
	FROM PRZELEW_DRUK pd
;


-- zadłużenie (CAŁOŚCIOWE)
INSERT INTO ZADLUZENIE_POZYCJA(
	 	INSTYTUCJA_ID, OSOBA_ID,
	    ZADLUZENIE_ID,
	    AKTUALNOSC, KWOTA, RODZAJ, STATUS)
    SELECT
    	ps.INSTYTUCJA_ID, ps.OSOBA_ID,
    	(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = p.OSOBA_ID
 				AND z.ROK = p.ROK
 				AND z.MIESIAC = p.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'CALOSC' as RODZAJ, 'W_REALIZACJI' as STATUS
    FROM PLATNOSC p
    	JOIN PLATNOSC_SKLADNIK ps ON p.ID = ps.PLATNOSC_ID
    UNION
    SELECT
    	w.INSTYTUCJA_ID, w.OSOBA_ID,
    	(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = w.MIESZKANIEC_ID
 				AND z.ROK = ows.ROK
 				AND z.MIESIAC = ows.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'CALOSC' as RODZAJ, 'W_REALIZACJI' as STATUS
    FROM WPLATA w
		JOIN OLD_WPLATA_SZCZEGOLY ows ON w.ID = ows.WPLATA_ID
	UNION
	SELECT
		oz.INSTYTUCJA_ID, oz.OSOBA_ID,
		(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = oz.MIESZKANIEC_ID
 				AND z.ROK = oz.ROK
 				AND z.MIESIAC = oz.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'CALOSC' as RODZAJ, 'W_REALIZACJI' as STATUS
	FROM ODPIS_ZWROT oz
	UNION
	SELECT
		pd.INSTYTUCJA_ID, pd.OSOBA_ID,
		(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = pd.MIESZKANIEC_ID
 				AND z.ROK = pd.ROK
 				AND z.MIESIAC = pd.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'CALOSC' as RODZAJ, 'W_REALIZACJI' as STATUS
	FROM PRZELEW_DRUK pd
;


-- zadłużenie (POBYT)
INSERT INTO ZADLUZENIE_POZYCJA(
	 	INSTYTUCJA_ID, OSOBA_ID,
	    ZADLUZENIE_ID,
	    AKTUALNOSC, KWOTA, RODZAJ, STATUS)
    SELECT
    	ps.INSTYTUCJA_ID, ps.OSOBA_ID,
    	(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = p.OSOBA_ID
 				AND z.ROK = p.ROK
 				AND z.MIESIAC = p.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'POBYT' as RODZAJ, 'W_REALIZACJI' as STATUS
    FROM PLATNOSC p
    	JOIN PLATNOSC_SKLADNIK ps ON p.ID = ps.PLATNOSC_ID
    UNION
    SELECT
    	w.INSTYTUCJA_ID, w.OSOBA_ID,
    	(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = w.MIESZKANIEC_ID
 				AND z.ROK = ows.ROK
 				AND z.MIESIAC = ows.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'POBYT' as RODZAJ, 'W_REALIZACJI' as STATUS
    FROM WPLATA w
		JOIN OLD_WPLATA_SZCZEGOLY ows ON w.ID = ows.WPLATA_ID
	UNION
	SELECT
		oz.INSTYTUCJA_ID, oz.OSOBA_ID,
		(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = oz.MIESZKANIEC_ID
 				AND z.ROK = oz.ROK
 				AND z.MIESIAC = oz.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'POBYT' as RODZAJ, 'W_REALIZACJI' as STATUS
	FROM ODPIS_ZWROT oz
	UNION
	SELECT
		pd.INSTYTUCJA_ID, pd.OSOBA_ID,
		(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = pd.MIESZKANIEC_ID
 				AND z.ROK = pd.ROK
 				AND z.MIESIAC = pd.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'POBYT' as RODZAJ, 'W_REALIZACJI' as STATUS
	FROM PRZELEW_DRUK pd
;


-- zadłużenie (FAKTURY)
INSERT INTO ZADLUZENIE_POZYCJA(
	 	INSTYTUCJA_ID, OSOBA_ID,
	    ZADLUZENIE_ID,
	    AKTUALNOSC, KWOTA, RODZAJ, STATUS)
    SELECT
    	ps.INSTYTUCJA_ID, ps.OSOBA_ID,
    	(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = p.OSOBA_ID
 				AND z.ROK = p.ROK
 				AND z.MIESIAC = p.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'FAKTURY' as RODZAJ, 'W_REALIZACJI' as STATUS
    FROM PLATNOSC p
    	JOIN PLATNOSC_SKLADNIK ps ON p.ID = ps.PLATNOSC_ID
    UNION
    SELECT
    	w.INSTYTUCJA_ID, w.OSOBA_ID,
    	(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = w.MIESZKANIEC_ID
 				AND z.ROK = ows.ROK
 				AND z.MIESIAC = ows.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'FAKTURY' as RODZAJ, 'W_REALIZACJI' as STATUS
    FROM WPLATA w
		JOIN OLD_WPLATA_SZCZEGOLY ows ON w.ID = ows.WPLATA_ID
	UNION
	SELECT
		oz.INSTYTUCJA_ID, oz.OSOBA_ID,
		(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = oz.MIESZKANIEC_ID
 				AND z.ROK = oz.ROK
 				AND z.MIESIAC = oz.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'FAKTURY' as RODZAJ, 'W_REALIZACJI' as STATUS
	FROM ODPIS_ZWROT oz
	UNION
	SELECT
		pd.INSTYTUCJA_ID, pd.OSOBA_ID,
		(
    		SELECT z.ID
    		FROM ZADLUZENIE z
    		WHERE
 				z.OSOBA_ID = pd.MIESZKANIEC_ID
 				AND z.ROK = pd.ROK
 				AND z.MIESIAC = pd.MIESIAC
    	) as ZADLUZENIE_ID,
    	'DIRTY' as AKTUALNOSC, '0.00' as KWOTA, 'FAKTURY' as RODZAJ, 'W_REALIZACJI' as STATUS
	FROM PRZELEW_DRUK pd
;


-- NALICZENIA ZA POBYT
-- tymczasowe pole potrzebne do pozniejszego uzupelnienia danych
ALTER TABLE NALICZENIE_POBYT ADD PLATNOSC_ID BIGINT(10);

-- dane dla osób
INSERT INTO NALICZENIE_POBYT (
        ZADLUZENIE_POZYCJA_ID,
        DATA_OBLICZENIA,
        KWOTA,
        PLATNOSC_ID)
	SELECT
		(
			SELECT zp.ID
			FROM ZADLUZENIE z
				JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
					AND z.OSOBA_ID = p.OSOBA_ID
					AND zp.OSOBA_ID = ps.OSOBA_ID
					AND zp.INSTYTUCJA_ID IS NULL
					AND z.ROK = p.ROK
					AND z.MIESIAC = p.MIESIAC
					AND zp.RODZAJ = 'POBYT'
		) as ZADLUZENIE_POZYCJA_ID,
		p.DATA_OBLICZENIA,
		ps.KWOTA,
		p.ID AS PLATNOSC_ID
	FROM PLATNOSC p
		JOIN PLATNOSC_SKLADNIK ps ON p.ID = ps.PLATNOSC_ID
			AND ps.OSOBA_ID IS NOT NULL
;
-- dane dla instytucji
INSERT INTO NALICZENIE_POBYT (
        ZADLUZENIE_POZYCJA_ID,
        DATA_OBLICZENIA,
        KWOTA,
        PLATNOSC_ID)
	SELECT
		(
			SELECT zp.ID
			FROM ZADLUZENIE z
				JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
					AND z.OSOBA_ID = p.OSOBA_ID
					AND zp.INSTYTUCJA_ID = ps.INSTYTUCJA_ID
					AND zp.OSOBA_ID IS NULL
					AND z.ROK = p.ROK
					AND z.MIESIAC = p.MIESIAC
					AND zp.RODZAJ = 'POBYT'
		) as ZADLUZENIE_POZYCJA_ID,
		p.DATA_OBLICZENIA,
		ps.KWOTA,
		p.ID as PLATNOSC_ID
	FROM PLATNOSC p
		JOIN PLATNOSC_SKLADNIK ps ON p.ID = ps.PLATNOSC_ID	
			AND ps.INSTYTUCJA_ID IS NOT NULL
;

-- powiązania z odpłatnościami
INSERT INTO NALICZENIE_PODSTAWA (
		NALICZENIE_ID, ODPLATNOSC_ID)
	SELECT
		np.ID AS NALICZENIE_ID, pp.ODPLATNOSC_ID
	FROM NALICZENIE_POBYT np
		JOIN PLATNOSC_PODSTAWA pp ON np.PLATNOSC_ID = pp.PLATNOSC_ID
;

-- usuwanie tymczasowej kolumny
ALTER TABLE NALICZENIE_POBYT DROP COLUMN PLATNOSC_ID;

-- PRZELEW DRUK
-- dla osób
UPDATE PRZELEW_DRUK pd SET
	pd.ZADLUZENIE_POZYCJA_ID = (
		SELECT zp.ID
		FROM ZADLUZENIE z
			JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
				AND z.OSOBA_ID = pd.MIESZKANIEC_ID
				AND z.ROK = pd.ROK
				AND z.MIESIAC = pd.MIESIAC
				AND zp.RODZAJ = 'CALOSC'
				AND zp.OSOBA_ID = pd.OSOBA_ID
				AND zp.INSTYTUCJA_ID IS NULL
	)
WHERE pd.OSOBA_ID IS NOT NULL;
-- dla instytucji
UPDATE PRZELEW_DRUK pd SET
	pd.ZADLUZENIE_POZYCJA_ID = (
		SELECT zp.ID
		FROM ZADLUZENIE z
			JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
				AND z.OSOBA_ID = pd.MIESZKANIEC_ID
				AND z.ROK = pd.ROK
				AND z.MIESIAC = pd.MIESIAC
				AND zp.RODZAJ = 'CALOSC'
				AND zp.INSTYTUCJA_ID = pd.INSTYTUCJA_ID
				AND zp.OSOBA_ID IS NULL
	)
WHERE pd.INSTYTUCJA_ID IS NOT NULL;
ALTER TABLE PRZELEW_DRUK ALTER COLUMN ZADLUZENIE_POZYCJA_ID SET NOT NULL;


-- ODPIS ZWROT
-- dla osób
UPDATE ODPIS_ZWROT oz SET
	oz.ZADLUZENIE_POZYCJA_ID = (
		SELECT zp.ID
		FROM ZADLUZENIE z
			JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
				AND z.OSOBA_ID = oz.MIESZKANIEC_ID
				AND z.ROK = oz.ROK
				AND z.MIESIAC = oz.MIESIAC
				AND zp.RODZAJ = 'POBYT'
				AND zp.OSOBA_ID = oz.OSOBA_ID
				AND zp.INSTYTUCJA_ID IS NULL
	)
WHERE oz.OSOBA_ID IS NOT NULL;
-- dla instytucji
UPDATE ODPIS_ZWROT oz SET
	oz.ZADLUZENIE_POZYCJA_ID = (
		SELECT zp.ID
		FROM ZADLUZENIE z
			JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
				AND z.OSOBA_ID = oz.MIESZKANIEC_ID
				AND z.ROK = oz.ROK
				AND z.MIESIAC = oz.MIESIAC
				AND zp.RODZAJ = 'POBYT'
				AND zp.INSTYTUCJA_ID = oz.INSTYTUCJA_ID
				AND zp.OSOBA_ID IS NULL
	)
WHERE oz.INSTYTUCJA_ID IS NOT NULL;
ALTER TABLE ODPIS_ZWROT ALTER COLUMN ZADLUZENIE_POZYCJA_ID SET NOT NULL;


-- WPLATA_SKLADNIK
-- osób
INSERT INTO WPLATA_SKLADNIK(
		WPLATA_ID,
	    ZADLUZENIE_POZYCJA_ID,
	    FAKTURA_ID,
	    KWOTA)
	SELECT
		ows.WPLATA_ID,
		(
			SELECT zp.ID
			FROM ZADLUZENIE z
				JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
					AND z.OSOBA_ID = w.MIESZKANIEC_ID
					AND z.ROK = ows.ROK
					AND z.MIESIAC = ows.MIESIAC
					AND zp.RODZAJ = ows.NA_POCZET
					AND zp.OSOBA_ID = w.OSOBA_ID
					AND zp.INSTYTUCJA_ID IS NULL
		) as ZADLUZENIE_POZYCJA_ID,
		ows.FAKTURA_ID,
		ows.KWOTA
	FROM WPLATA w
		JOIN OLD_WPLATA_SZCZEGOLY ows ON w.ID = ows.WPLATA_ID
			AND w.OSOBA_ID IS NOT NULL
;
-- instytucji
INSERT INTO WPLATA_SKLADNIK(
		WPLATA_ID,
	    ZADLUZENIE_POZYCJA_ID,
	    FAKTURA_ID,
	    KWOTA)
	SELECT
		ows.WPLATA_ID,
		(
			SELECT zp.ID
			FROM ZADLUZENIE z
				JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
					AND z.OSOBA_ID = w.MIESZKANIEC_ID
					AND z.ROK = ows.ROK
					AND z.MIESIAC = ows.MIESIAC
					AND zp.RODZAJ = ows.NA_POCZET
					AND zp.INSTYTUCJA_ID = w.INSTYTUCJA_ID
					AND zp.OSOBA_ID IS NULL
		) as ZADLUZENIE_POZYCJA_ID,
		ows.FAKTURA_ID,
		ows.KWOTA
	FROM WPLATA w
		JOIN OLD_WPLATA_SZCZEGOLY ows ON w.ID = ows.WPLATA_ID
			AND w.INSTYTUCJA_ID IS NOT NULL
;


--//@UNDO
-- SQL to undo the change goes here.

