--// migracja import arisco.
-- Migration SQL that makes the change goes here.

-- sądy
CREATE TABLE SAD (
    ID IDENTITY NOT NULL,
    ADRES_ID BIGINT(10),
    NAZWA VARCHAR(200) NOT NULL,
    CONSTRAINT SAD_pk PRIMARY KEY (ID)
);

ALTER TABLE SAD ADD CONSTRAINT ADRES_SAD_fk
	FOREIGN KEY (ADRES_ID)
	REFERENCES ADRES (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- postanowienie sądu
ALTER TABLE POSTANOWIENIE_SADU ADD SAD_ID BIGINT(10);
ALTER TABLE POSTANOWIENIE_SADU ADD ZAKRES_ID BIGINT(10);
ALTER TABLE POSTANOWIENIE_SADU ADD DATA_OD DATE;
ALTER TABLE POSTANOWIENIE_SADU ADD UWAGI LONGVARCHAR;
ALTER TABLE POSTANOWIENIE_SADU ADD CONSTRAINT SLOWO_ZAKRES_POSTANOWIENIE_SADU_fk
	FOREIGN KEY (ZAKRES_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE POSTANOWIENIE_SADU ADD CONSTRAINT SAD_POSTANOWIENIE_SADU_fk
	FOREIGN KEY (SAD_ID)
	REFERENCES SAD (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

-- orzeczenie sądu
ALTER TABLE POSTANOWIENIE_SADU ADD OPIEKUN_ID BIGINT(10);

ALTER TABLE POSTANOWIENIE_SADU ADD CONSTRAINT OPIEKUN_POSTANOWIENIE_SADU_fk
	FOREIGN KEY (OPIEKUN_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- decyzja umieszczająca
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_ORGANU_WYDAJACEGO_DEC_UMIESZCZAJACA');
CREATE TABLE DECYZJA_UMIESZCZAJACA (
    ID IDENTITY NOT NULL,
    EWIDENCJA_ID BIGINT(10) NOT NULL,
    KTO_WYDAL_ID BIGINT(10),
    NR VARCHAR(50) NOT NULL,
    DATA_WPLYWU DATE,
    DATA_WYDANIA DATE NOT NULL,
    CONSTRAINT DECYZJA_UMIESZCZAJACA_pk PRIMARY KEY (ID)
);
ALTER TABLE DECYZJA_UMIESZCZAJACA ADD CONSTRAINT EWIDENCJA_DPS_DECYZJA_UMIESZCZAJACA_fk
	FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE DECYZJA_UMIESZCZAJACA ADD CONSTRAINT SLOWO_KTO_WYDAL_DECYZJA_UMIESZCZAJACA_fk
	FOREIGN KEY (KTO_WYDAL_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

-- profil działalności domu
CREATE TABLE DPS_JEDNOSTKA_PROFIL (
    NUMER VARCHAR(50) NOT NULL,
    DPS_JEDNOSTKA_ID BIGINT(7) NOT NULL,
    RODZAJ VARCHAR(50) NOT NULL,
    LICZBA_MIEJSC INTEGER,
    LICZBA_MIEJSC_K INTEGER,
    LICZBA_MIEJSC_M INTEGER,
    CONSTRAINT DPS_JEDNOSTKA_PROFIL_pk PRIMARY KEY (NUMER, DPS_JEDNOSTKA_ID)
);
ALTER TABLE DPS_JEDNOSTKA_PROFIL ADD CONSTRAINT DPS_JEDNOSTKA_PROFIL_DZIALANOSCI_fk
	FOREIGN KEY (DPS_JEDNOSTKA_ID)
	REFERENCES DPS_JEDNOSTKA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	-- rodzaj profilu
INSERT INTO DPS_JEDNOSTKA_PROFIL(NUMER, DPS_JEDNOSTKA_ID, RODZAJ)
	VALUES('I', (SELECT j.ID FROM DPS_JEDNOSTKA j LIMIT 1), (SELECT j.RODZAJ FROM DPS_JEDNOSTKA j LIMIT 1));
ALTER TABLE DPS_JEDNOSTKA DROP COLUMN RODZAJ;
	-- liczba miejsc
UPDATE DPS_JEDNOSTKA_PROFIL dp SET
	dp.LICZBA_MIEJSC = (
			SELECT WARTOSC_I
			FROM DPS_JEDNOSTKA_DANE dd
			WHERE dd.DPS_JEDNOSTKA_ID = dp.DPS_JEDNOSTKA_ID
				AND dd.TYP = 'LICZBA_MIEJSC'
		),
	dp.LICZBA_MIEJSC_K = (
			SELECT WARTOSC_I
			FROM DPS_JEDNOSTKA_DANE dd
			WHERE dd.DPS_JEDNOSTKA_ID = dp.DPS_JEDNOSTKA_ID
				AND dd.TYP = 'LICZBA_MIEJSC_K'
		),
	dp.LICZBA_MIEJSC_M = (
			SELECT WARTOSC_I
			FROM DPS_JEDNOSTKA_DANE dd
			WHERE dd.DPS_JEDNOSTKA_ID = dp.DPS_JEDNOSTKA_ID
				AND dd.TYP = 'LICZBA_MIEJSC_M'
		)
;
DELETE FROM DPS_JEDNOSTKA_DANE dd WHERE dd.TYP = 'LICZBA_MIEJSC';
DELETE FROM DPS_JEDNOSTKA_DANE dd WHERE dd.TYP = 'LICZBA_MIEJSC_K';
DELETE FROM DPS_JEDNOSTKA_DANE dd WHERE dd.TYP = 'LICZBA_MIEJSC_M';

ALTER TABLE EWIDENCJA_DPS ADD PROFIL_DOMU VARCHAR(50);

-- orzeczenie o niepełnosprawności
ALTER TABLE ORZECZ_O_NIEPELNOSPRAW ADD RODZAJ_ORZECZNICTWA VARCHAR(50);
ALTER TABLE ORZECZ_O_NIEPELNOSPRAW ADD WYDANE_PRZEZ_ID BIGINT(10);
ALTER TABLE ORZECZ_O_NIEPELNOSPRAW ADD UWAGI LONGVARCHAR;
ALTER TABLE ORZECZ_O_NIEPELNOSPRAW ADD CONSTRAINT SLOWO_ORZECZ_O_NIEPELNOSPRAW_fk
	FOREIGN KEY (WYDANE_PRZEZ_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_ORGANU_WYDAJACEGO_ORZ_NIEPEL');
INSERT INTO SLOWO(SLOWNIK_ID, WART_STRING, KOD)
	SELECT 
		(SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_ORGANU_WYDAJACEGO_ORZ_NIEPEL') AS SLOWNIK_ID,
		tmp.WART_STRING,
		LPAD(
			CAST(
				(ROWNUM() +
						SELECT CAST(COALESCE(MAX(s.KOD), '-1') as INTEGER) as MAX_KOD
						FROM SLOWNIK sl
							JOIN SLOWO s ON sl.ID = s.SLOWNIK_ID
								AND sl.ID = (
									SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_ORGANU_WYDAJACEGO_ORZ_NIEPEL'))
					as VARCHAR), 3, '0') as KOD
	FROM (
		SELECT
			DISTINCT o.WYDANE_PRZEZ as WART_STRING
		FROM ORZECZ_O_NIEPELNOSPRAW o
		WHERE
			o.WYDANE_PRZEZ IS NOT NULL AND o.WYDANE_PRZEZ != ''
	) as tmp;
UPDATE ORZECZ_O_NIEPELNOSPRAW o
	SET o.WYDANE_PRZEZ_ID = (
		SELECT s.ID
		FROM SLOWO s
		WHERE
			s.SLOWNIK_ID = (SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_ORGANU_WYDAJACEGO_ORZ_NIEPEL')
			AND s.WART_STRING = o.WYDANE_PRZEZ
	);
ALTER TABLE ORZECZ_O_NIEPELNOSPRAW DROP COLUMN WYDANE_PRZEZ;


-- dokumenty operacji
CREATE TABLE DOKUMENT_OPERACJI (
    ID IDENTITY NOT NULL,
    TYP_ID BIGINT(50) NOT NULL,
    DATA DATE,
    NR VARCHAR(50),
    CONSTRAINT DOKUMENT_OPERACJI_pk PRIMARY KEY (ID)
);
ALTER TABLE NALICZENIE_POBYT ADD DOKUMENT_ID BIGINT(10);
ALTER TABLE NALICZENIE_POBYT ADD UWAGI LONGVARCHAR;
ALTER TABLE ODPIS_ZWROT ADD DOKUMENT_ID BIGINT(10);
ALTER TABLE ODPIS_ZWROT ADD UWAGI LONGVARCHAR;
ALTER TABLE WPLATA ADD DOKUMENT_ID BIGINT(10);
ALTER TABLE WPLATA ADD UWAGI LONGVARCHAR;
ALTER TABLE DOKUMENT_OPERACJI ADD CONSTRAINT SLOWO_DOKUMENT_TYP_OPERACJI_fk
	FOREIGN KEY (TYP_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE NALICZENIE_POBYT ADD CONSTRAINT SLOWO_DOK_NALICZENIE_POBYT_fk
	FOREIGN KEY (DOKUMENT_ID)
	REFERENCES DOKUMENT_OPERACJI (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE ODPIS_ZWROT ADD CONSTRAINT SLOWO_DOK_ODPIS_ZWROT_fk
	FOREIGN KEY (DOKUMENT_ID)
	REFERENCES DOKUMENT_OPERACJI (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE WPLATA ADD CONSTRAINT SLOWO_DOK_WPLATA_fk
	FOREIGN KEY (DOKUMENT_ID)
	REFERENCES DOKUMENT_OPERACJI (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_TYPU_DOKUMENTU_OPERACJI');
	
-- wpisy ewidencyjne
	-- usuwanie związanych widoków
	DROP VIEW IF EXISTS AKTUALNE_WPISY_EWIDENCJI_OSOB;
	DROP VIEW IF EXISTS AKTUALNE_POKOJE_MIESZKANCOW;
	DROP VIEW IF EXISTS AKTUALNE_DAWKI_LEKOW;
	DROP VIEW IF EXISTS MIESZKANCY;
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_MIEJSCA_PRZYJSCIA_DO_DPS');
ALTER TABLE EWIDENCJA_DPS ADD SKAD_PRZYSZEDL_ID BIGINT(10);
ALTER TABLE EWIDENCJA_DPS ADD CONSTRAINT SLOWO_SKAD_PRZYSZEDL_EWIDENCJA_DPS_fk
	FOREIGN KEY (SKAD_PRZYSZEDL_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
INSERT INTO SLOWO(SLOWNIK_ID, WART_STRING, KOD)
	VALUES((SELECT ID FROM SLOWNIK s WHERE s.NAZWA = 'KOD_MIEJSCA_PRZYJSCIA_DO_DPS'), 'inny DPS', '001');
UPDATE EWIDENCJA_DPS ewDps
	SET ewDps.SKAD_PRZYSZEDL_ID =
		(
			SELECT sl.ID
			FROM SLOWO sl
				JOIN SLOWNIK s ON sl.SLOWNIK_ID = s.ID
					AND s.NAZWA = 'KOD_MIEJSCA_PRZYJSCIA_DO_DPS'
					AND sl.KOD = '001'
		)
	WHERE ewDps.PRZENIESIENIE_Z_INNY_DPS IS NOT NULL AND ewDps.PRZENIESIENIE_Z_INNY_DPS = TRUE;
ALTER TABLE EWIDENCJA_DPS DROP COLUMN PRZENIESIENIE_Z_INNY_DPS;
	-- utworzenie widoków na nowo
CREATE VIEW AKTUALNE_WPISY_EWIDENCJI_OSOB AS
	SELECT ew.*
	FROM EWIDENCJA_DPS ew
		LEFT OUTER JOIN EWIDENCJA_DPS nEw ON nEw.EWID_POPRZEDNI_WPIS_ID = ew.ID
	WHERE nEw.ID IS NULL;
CREATE VIEW AKTUALNE_POKOJE_MIESZKANCOW AS
	SELECT ewDps.OSOBA_ID as MIESZKANIEC_ID, ewPok.*
	FROM EWIDENCJA_DPS ewDps
		JOIN EWIDENCJA_POKOJE ewPok ON ewDps.ID = ewPok.EWIDENCJA_DPS_ID
			AND ewDps.TYP = 'MIESZKANIEC' AND ewDps.DATA_DO IS NULL -- tylko widok pokoi aktualnych mieszkańców DPS
		LEFT OUTER JOIN EWIDENCJA_POKOJE nEwPok ON ewPok.ID = nEwPok.POPRZEDNI_POKOJ_ID
	WHERE
		nEwPok.ID IS NULL;
CREATE VIEW AKTUALNE_DAWKI_LEKOW AS
	SELECT ewDps.OSOBA_ID, d.*
		FROM AKTUALNE_WPISY_EWIDENCJI_OSOB ewDps
			JOIN DAWKOWANIE d ON d.EWIDENCJA_DPS_ID = ewDps.ID
				AND d.DATA_OD <= CURRENT_DATE()
			LEFT OUTER JOIN DAWKOWANIE najD ON najD.EWIDENCJA_DPS_ID = ewDps.ID
				AND najD.POPRZEDNIE_DAWKOWANIE_ID = d.ID
	WHERE
		najD.ID IS NULL;
CREATE VIEW MIESZKANCY AS
	SELECT os.*, ew.id as EWIDENCJA_ID, ew.DATA_OD, ew.DATA_DO, ew.NUMER_EWIDENCYJNY
	FROM OSOBA os
    	JOIN EWIDENCJA_DPS ew ON os.id = ew.osoba_id
			AND ew.TYP = 'MIESZKANIEC';

-- nieobecność
UPDATE NIEOBECNOSC n SET n.STATUS = 'DO_ROZLICZENIA' WHERE n.STATUS = 'W_REALIZACJI';

-- pobierane świadczenie
INSERT INTO SLOWO (SLOWNIK_ID, KOD, WART_STRING) VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_SWIADCZENIA'), '674', 'Alimenty');
INSERT INTO SLOWO (SLOWNIK_ID, KOD, WART_STRING) VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_SWIADCZENIA'), '675', 'Umowa dzierżawy');


-- usuwanie indeksu
ALTER TABLE DECYZJA_KIERUJACA DROP CONSTRAINT OSOBA_DECYZJA_KIERUJACA_fk;
DROP INDEX IF EXISTS PR_UNIKALNA_DEC_KIER_NA_DZIEN;

-- indeksy w bazie
ALTER TABLE DECYZJA_KIERUJACA ADD CONSTRAINT OSOBA_DECYZJA_KIERUJACA_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
CREATE UNIQUE INDEX PR_UNIKALNA_DEC_KIER_NA_DZIEN
    ON DECYZJA_KIERUJACA(OSOBA_ID, TYP, DATA_WYDANIA);
    
--//@UNDO
-- SQL to undo the change goes here.

