--// migracja nota.
-- Migration SQL that makes the change goes here.

-- nowe swiadczenie
INSERT INTO SLOWO (SLOWNIK_ID, KOD, WART_STRING) VALUES (1, '676', 'Doch. z gosp. rolnego');

-- autonumeracja
INSERT INTO AUTONUMER(TYP, FORMAT, WARTOSC) VALUES ('NOTA_ODPLATNOSC', '${nr}', 1);

-- tabele not

CREATE TABLE NOTA_ODPLATNOSC (
    ID IDENTITY NOT NULL,
    INSTYTUCJA_ID BIGINT(10),
    PRACOWNIK_ID BIGINT(10) NOT NULL,
    SZABLON_WYDRUKU_ID BIGINT(10),
    DATA DATE NOT NULL,
    NR VARCHAR(50) NOT NULL,
    TYP VARCHAR(50) NOT NULL,
    CONSTRAINT NOTA_ODPLATNOSC_pk PRIMARY KEY (ID)
);

CREATE TABLE NOTA_ODPLATNOSC_POZYCJA (
    ID IDENTITY NOT NULL,
    KONTO_BANKOWE_ID BIGINT(10),
    NOTA_ID BIGINT(10) NOT NULL,
    FAKTURA_ID BIGINT(10),
    WPLATA_ID BIGINT(10),
    ZADLUZENIE_POZYCJA_ID BIGINT(10) NOT NULL,
    ZWROT_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    KWOTA_ODSETEK DECIMAL(10,2) NOT NULL,
    CONSTRAINT NOTA_ODPLATNOSC_POZYCJA_pk PRIMARY KEY (ID)
);

ALTER TABLE NOTA_ODPLATNOSC ADD CONSTRAINT SZABLON_WYDRUKU_NOTA_ODPLATNOSC_fk
	FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE NOTA_ODPLATNOSC ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_NOTA_ODPLATNOSC_fk
	FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE NOTA_ODPLATNOSC ADD CONSTRAINT PRACOWNIK_NOTA_ODPLATNOSC_fk
	FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD CONSTRAINT NOTA_ODPLATNOSC_NOTA_ODPLATNOSC_POZYCJA_fk
	FOREIGN KEY (NOTA_ID)
	REFERENCES NOTA_ODPLATNOSC (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD CONSTRAINT FAKTURA_NOTA_ODPLATNOSC_POZYCJA_fk
	FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD CONSTRAINT ZADLUZENIE_POZYCJA_NOTA_ODPLATNOSC_POZYCJA_fk
	FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD CONSTRAINT ODPIS_ZWROT_NOTA_ODPLATNOSC_POZYCJA_fk
	FOREIGN KEY (ZWROT_ID)
	REFERENCES ODPIS_ZWROT (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD CONSTRAINT WPLATA_NOTA_ODPLATNOSC_POZYCJA_fk
	FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD CONSTRAINT KONTO_BANKOWE_NOTA_ODPLATNOSC_POZYCJA_fk
	FOREIGN KEY (KONTO_BANKOWE_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

-- poprawki przy przeliczaniu dlugu
UPDATE ZADLUZENIE_POZYCJA SET AKTUALNOSC = 'DIRTY';
	
--//@UNDO
-- SQL to undo the change goes here.

