--// migracja wprowadzanie wplat.
-- Migration SQL that makes the change goes here.

-- słownik dokumentów jest niepotrzebny
ALTER TABLE DOKUMENT_OPERACJI DROP CONSTRAINT IF EXISTS SLOWO_DOKUMENT_TYP_OPERACJI_fk;
ALTER TABLE NALICZENIE_POBYT DROP CONSTRAINT IF EXISTS SLOWO_DOK_NALICZENIE_POBYT_fk;
ALTER TABLE ODPIS_ZWROT DROP CONSTRAINT IF EXISTS SLOWO_DOK_ODPIS_ZWROT_fk;
ALTER TABLE WPLATA DROP CONSTRAINT IF EXISTS SLOWO_DOK_WPLATA_fk;

-- 2013-12-01 (wyłączenie triggera przy update)
-- poprawka potrzebna wyłącznie dla starych baz danych; nieaktualizowanych od miesięcy
DROP TRIGGER IF EXISTS AUPD_NALICZENIE_POBYT;
UPDATE NALICZENIE_POBYT np SET np.DOKUMENT_ID = null;
-- 2013-12-01 przywrócenie triggera
CREATE TRIGGER AUPD_NALICZENIE_POBYT AFTER
	UPDATE ON NALICZENIE_POBYT FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.naliczanieOplat.pobyt.AfterNaliczaniePobytUpdate";

UPDATE ODPIS_ZWROT oz SET oz.DOKUMENT_ID = null;
UPDATE WPLATA w SET w.DOKUMENT_ID = null;

DELETE FROM SLOWO s WHERE s.SLOWNIK_ID = (SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_TYPU_DOKUMENTU_OPERACJI');
DELETE FROM SLOWNIK WHERE NAZWA = 'KOD_TYPU_DOKUMENTU_OPERACJI';

DROP TABLE IF EXISTS DOKUMENT_OPERACJI;

ALTER TABLE NALICZENIE_POBYT DROP COLUMN DOKUMENT_ID;
ALTER TABLE ODPIS_ZWROT DROP COLUMN DOKUMENT_ID;
ALTER TABLE WPLATA DROP COLUMN DOKUMENT_ID;


-- pobierane świadczenie
ALTER TABLE POBIERANE_SWIADCZENIE ADD RODZAJ_ODBIORU VARCHAR(50);
ALTER TABLE POBIERANE_SWIADCZENIE ADD INSTYTUCJA_DOPLACAJACA_ID BIGINT(10);
ALTER TABLE POBIERANE_SWIADCZENIE ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_POBIERANE_SWIADCZENIE_fk
	FOREIGN KEY (INSTYTUCJA_DOPLACAJACA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

-- daty księgowania operacji
ALTER TABLE NALICZENIE_POBYT ADD DATA_KSIEGOWANIA DATE;
ALTER TABLE ODPIS_ZWROT ADD DATA_KSIEGOWANIA DATE;
ALTER TABLE WPLATA ADD DATA_KSIEGOWANIA DATE;


-- zmiany we wpłatach (podpięcie świadczenia)
ALTER TABLE WPLATA ADD SWIADCZENIE_ID BIGINT(10);
ALTER TABLE WPLATA ADD CONSTRAINT POBIERANE_SWIADCZENIE_WPLATA_fk
	FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES POBIERANE_SWIADCZENIE (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


--//@UNDO
-- SQL to undo the change goes here.

