--// depozyty_glowne_tabele.
-- Migration SQL that makes the change goes here.

-- missing tables 
--	... DEPOZYT_P_FAKTURA
CREATE TABLE DEPOZYT_P_FAKTURA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	FAKTURA_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	WPLATA_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_FAKTURA_PK PRIMARY KEY (ID)
);
--	... DEPOZYT_P_KONTO
CREATE TABLE DEPOZYT_P_KONTO
(
	ID IDENTITY NOT NULL,
	KONTO_BANKOWE_ID bigint NOT NULL,
	OSOBA_ID bigint NOT NULL,
	ZAMKNIETE boolean,
	CONSTRAINT DEPOZYT_P_KONTO_PK PRIMARY KEY (ID)
);
--	... DEPOZYT_P_NOTA
CREATE TABLE DEPOZYT_P_NOTA
(
	ID IDENTITY NOT NULL,
	DATA date NOT NULL,
	DATA_KSIEGOWANIA date,
	CONSTRAINT DEPOZYT_P_NOTA_PK PRIMARY KEY (ID)
);
--	... DEPOZYT_P_NOTA_OPERACJA
CREATE TABLE DEPOZYT_P_NOTA_OPERACJA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	DP_NOTA_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	ZADLUZENIE_WYROWNANIE_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_NOTA_OPERACJA_PK PRIMARY KEY (ID)
);
--	... DEPOZYT_P_ODSETKI
CREATE TABLE DEPOZYT_P_ODSETKI
(
	ID IDENTITY NOT NULL,
	DATA date NOT NULL,
	DATA_KSIEGOWANIA date,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT DEPOZYT_P_ODSETKI_PK PRIMARY KEY (ID)
);
--	... DEPOZYT_P_ODSETKI_POZYCJA
CREATE TABLE DEPOZYT_P_ODSETKI_POZYCJA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	DP_ODSETKI_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_ODSETKI_POZYCJA_PK PRIMARY KEY (ID)
);
--	... DEPOZYT_P_SW_WPLATA
CREATE TABLE DEPOZYT_P_SW_WPLATA
(
	ID IDENTITY NOT NULL,
	TERMIN_WYPLATY_ID bigint NOT NULL,
	DATA date NOT NULL,
	DATA_KSIEGOWANIA date,
	MIESIAC int NOT NULL,
	ROK int NOT NULL,
	CONSTRAINT DEPOZYT_P_SW_WPLATA_PK PRIMARY KEY (ID)
);
--	... DEPOZYT_P_SW_WPL_POZYCJA
CREATE TABLE DEPOZYT_P_SW_WPL_POZYCJA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	SWIADCZENIE_WPLATA_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_SW_WPL_POZYCJA_PK PRIMARY KEY (ID)
);

-- missing columns - NONE 

-- data migration (fill it if necessary)

-- changed foreign key - NONE 

-- unexpected(deleted) foreign key - NONE 

-- changed tables - NONE 

-- changed columns - NONE 

-- unexpected(deleted) columns - NONE 

-- unexpected(deleted) tables - NONE 

-- missing foreign keys 
--	... DEPOZYT_K_DEPOZYT_FAKTURA_FK(DEPOZYT_P_FAKTURA.DP_KONTO_ID -> DEPOZYT_P_KONTO.ID)
ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT DEPOZYT_K_DEPOZYT_FAKTURA_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... DP_KONTO_DP_NOTA_OPERACJA_FK(DEPOZYT_P_NOTA_OPERACJA.DP_KONTO_ID -> DEPOZYT_P_KONTO.ID)
ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT DP_KONTO_DP_NOTA_OPERACJA_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION;
--	... DP_KONTO_DP_ODSETKI_OPERACJA_FK(DEPOZYT_P_ODSETKI_POZYCJA.DP_KONTO_ID -> DEPOZYT_P_KONTO.ID)
ALTER TABLE DEPOZYT_P_ODSETKI_POZYCJA
	ADD CONSTRAINT DP_KONTO_DP_ODSETKI_OPERACJA_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... DP_NOTA_OPERACJA_ZW_POZYCJA_FK(DEPOZYT_P_NOTA_OPERACJA.ZADLUZENIE_WYROWNANIE_ID -> ZADLUZENIE_WYROWNANIE.ID)
ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT DP_NOTA_OPERACJA_ZW_POZYCJA_FK FOREIGN KEY (ZADLUZENIE_WYROWNANIE_ID)
	REFERENCES ZADLUZENIE_WYROWNANIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION;
--	... DP_OSETKI_DP_ODSETKI_POZYCJA_FK(DEPOZYT_P_ODSETKI_POZYCJA.DP_ODSETKI_ID -> DEPOZYT_P_ODSETKI.ID)
ALTER TABLE DEPOZYT_P_ODSETKI_POZYCJA
	ADD CONSTRAINT DP_OSETKI_DP_ODSETKI_POZYCJA_FK FOREIGN KEY (DP_ODSETKI_ID)
	REFERENCES DEPOZYT_P_ODSETKI (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... DP_P_NOTA_DP_NOTA_OPERACJA_FK(DEPOZYT_P_NOTA_OPERACJA.DP_NOTA_ID -> DEPOZYT_P_NOTA.ID)
ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT DP_P_NOTA_DP_NOTA_OPERACJA_FK FOREIGN KEY (DP_NOTA_ID)
	REFERENCES DEPOZYT_P_NOTA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... DP_SWIADCZENIE_W_W_POZYCJA_FK(DEPOZYT_P_SW_WPL_POZYCJA.SWIADCZENIE_WPLATA_ID -> DEPOZYT_P_SW_WPLATA.ID)
ALTER TABLE DEPOZYT_P_SW_WPL_POZYCJA
	ADD CONSTRAINT DP_SWIADCZENIE_W_W_POZYCJA_FK FOREIGN KEY (SWIADCZENIE_WPLATA_ID)
	REFERENCES DEPOZYT_P_SW_WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... FAKTURA_DP_OPERACJA_FK(DEPOZYT_P_FAKTURA.FAKTURA_ID -> FAKTURA.ID)
ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT FAKTURA_DP_OPERACJA_FK FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... KONTO_BANKOWE_DEPOZYT_FK(DEPOZYT_P_KONTO.KONTO_BANKOWE_ID -> KONTO_BANKOWE.ID)
ALTER TABLE DEPOZYT_P_KONTO
	ADD CONSTRAINT KONTO_BANKOWE_DEPOZYT_FK FOREIGN KEY (KONTO_BANKOWE_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION;
--	... KONTO_W_SWIADCZNIE_POZ_FK(DEPOZYT_P_SW_WPL_POZYCJA.DP_KONTO_ID -> DEPOZYT_P_KONTO.ID)
ALTER TABLE DEPOZYT_P_SW_WPL_POZYCJA
	ADD CONSTRAINT KONTO_W_SWIADCZNIE_POZ_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION;
--	... M_OPERACJA_DP_NOTA_OPERACJA_FK(DEPOZYT_P_NOTA_OPERACJA.M_OPERACJA_ID -> MAGAZYN_OPERACJA.ID)
ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT M_OPERACJA_DP_NOTA_OPERACJA_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... M_OPERACJA_DP_ODSETKI_POZYCJA_FK(DEPOZYT_P_ODSETKI_POZYCJA.M_OPERACJA_ID -> MAGAZYN_OPERACJA.ID)
ALTER TABLE DEPOZYT_P_ODSETKI_POZYCJA
	ADD CONSTRAINT M_OPERACJA_DP_ODSETKI_POZYCJA_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... M_OPERACJA_DP_OPERACJA_FK(DEPOZYT_P_FAKTURA.M_OPERACJA_ID -> MAGAZYN_OPERACJA.ID)
ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT M_OPERACJA_DP_OPERACJA_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... M_OPERACJA_W_DP_SWIADCZENIE_FK(DEPOZYT_P_SW_WPL_POZYCJA.M_OPERACJA_ID -> MAGAZYN_OPERACJA.ID)
ALTER TABLE DEPOZYT_P_SW_WPL_POZYCJA
	ADD CONSTRAINT M_OPERACJA_W_DP_SWIADCZENIE_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;
--	... OSOBA_KONTO_DEPOZYT_FK(DEPOZYT_P_KONTO.OSOBA_ID -> OSOBA.ID)
ALTER TABLE DEPOZYT_P_KONTO
	ADD CONSTRAINT OSOBA_KONTO_DEPOZYT_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION;
--	... TERMIN_WYPL_DP_WPLATA_FK(DEPOZYT_P_SW_WPLATA.TERMIN_WYPLATY_ID -> TERMIN_WYPLATY.ID)
ALTER TABLE DEPOZYT_P_SW_WPLATA
	ADD CONSTRAINT TERMIN_WYPL_DP_WPLATA_FK FOREIGN KEY (TERMIN_WYPLATY_ID)
	REFERENCES TERMIN_WYPLATY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION;
--	... WPLATA_DP_FAKTURA_OPERACJA_FK(DEPOZYT_P_FAKTURA.WPLATA_ID -> WPLATA.ID)
ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT WPLATA_DP_FAKTURA_OPERACJA_FK FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE;

-- other
-- not supported for automatically generation
CREATE VIEW DP_BILANS_FAKTURY AS
	SELECT f.DP_KONTO_ID, SUM(mo.ILOSC) as BILANS
	FROM DEPOZYT_P_FAKTURA f
		JOIN MAGAZYN_OPERACJA mo ON f.M_OPERACJA_ID = mo.ID
	GROUP BY f.DP_KONTO_ID;
	
CREATE VIEW DP_BILANS_ODSETKI AS
	SELECT o.DP_KONTO_ID, SUM(mo.ILOSC) as BILANS
	FROM DEPOZYT_P_ODSETKI_POZYCJA o
		JOIN MAGAZYN_OPERACJA mo ON o.M_OPERACJA_ID = mo.ID
	GROUP BY o.DP_KONTO_ID;
	
CREATE VIEW DP_BILANS_NOTY AS
	SELECT n.DP_KONTO_ID, SUM(mo.ILOSC) as BILANS
	FROM DEPOZYT_P_NOTA_OPERACJA n
		JOIN MAGAZYN_OPERACJA mo ON n.M_OPERACJA_ID = mo.ID
	GROUP BY n.DP_KONTO_ID;

CREATE VIEW DP_BILANS_SW_WPLATA AS
	SELECT swp.DP_KONTO_ID, SUM(mo.ILOSC) as BILANS
	FROM DEPOZYT_P_SW_WPL_POZYCJA swp
		JOIN MAGAZYN_OPERACJA mo ON swp.M_OPERACJA_ID = mo.ID
	GROUP BY swp.DP_KONTO_ID;

--//@UNDO
-- SQL to undo the change goes here.

