--// nota_wyrownawcza.
-- Migration SQL that makes the change goes here.

-- missing tables - NONE 

-- missing columns - NONE 

-- data migration (fill it if necessary)

-- #3526
-- ID TRANSFERU
ALTER TABLE NOTA_ODPLATNOSC ADD ID_TRANSFERU BIGINT(10);
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD ID_TRANSFERU BIGINT(10);

INSERT INTO NOTA_ODPLATNOSC (INSTYTUCJA_ID, PRACOWNIK_ID, SZABLON_WYDRUKU_ID, DATA, NR, TYP, SZABLON_WYDRUKU_2_ID, STATUS, RODZAJ_ZADLUZENIA, ID_TRANSFERU)
	SELECT DISTINCT no.INSTYTUCJA_ID, no.PRACOWNIK_ID, NULL as SZABLON_WYDRUKU, no.DATA, CONCAT(no.NR, '-w') as NR,
		'WYROWNANIA' as TYP, NULL as SZABLON_WYDRUKU_2_ID, 'ROZLICZONA' as STATUS, no.RODZAJ_ZADLUZENIA, no.ID as ID_TRANSFERU
	FROM NOTA_ODPLATNOSC_POZYCJA nop
		JOIN ZADLUZENIE_WYROWNANIE zw ON nop.ID = zw.NOTA_POZYCJA_ID 
			AND zw.STATUS = 'WLICZONE'
		JOIN NOTA_ODPLATNOSC no ON no.ID = nop.NOTA_ID;
		
INSERT INTO NOTA_ODPLATNOSC_POZYCJA (NOTA_ID, KWOTA, KONTO_ID, STATUS, KWOTA_ODPISU, ID_TRANSFERU)
	SELECT DISTINCT no.ID as NOTA_ID, 0.0 as KWOTA, null as KONTO_ID, 'ROZLICZONA' as STATUS, 0.0 as KWOTA_ODPISU, nop.ID as ID_TRANSFERU
	FROM NOTA_ODPLATNOSC_POZYCJA nop
		JOIN ZADLUZENIE_WYROWNANIE zw ON nop.ID = zw.NOTA_POZYCJA_ID
			AND zw.STATUS = 'WLICZONE'
		JOIN NOTA_ODPLATNOSC no ON no.ID_TRANSFERU = nop.NOTA_ID;
		
UPDATE ZADLUZENIE_WYROWNANIE zw SET zw.NOTA_POZYCJA_ID = (
	SELECT nop.ID
	FROM NOTA_ODPLATNOSC_POZYCJA nop
	WHERE nop.ID_TRANSFERU = zw.NOTA_POZYCJA_ID
)
WHERE zw.STATUS = 'WLICZONE';

ALTER TABLE NOTA_ODPLATNOSC DROP COLUMN ID_TRANSFERU;
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA DROP COLUMN ID_TRANSFERU;

-- usuwanie pozycji not, które nie mają już wyrównań
DELETE FROM NOTA_ODPLATNOSC_POZYCJA nop
	WHERE NOT EXISTS (SELECT zw.ID FROM ZADLUZENIE_WYROWNANIE zw WHERE zw.NOTA_POZYCJA_ID = nop.ID);

-- changed foreign key - NONE 

-- unexpected(deleted) foreign key - NONE 

-- changed tables - NONE 

-- changed columns - NONE 

-- unexpected(deleted) columns - NONE 

-- unexpected(deleted) tables - NONE 

-- missing foreign keys - NONE 

-- other
-- not supported for automatically generation


--//@UNDO
-- SQL to undo the change goes here.

