--// migracja systemu magazynowego.
-- Migration SQL that makes the change goes here.

CREATE TABLE MAGAZYN (
                TYP VARCHAR(50) NOT NULL,
                CONSTRAINT MAGAZYN_pk PRIMARY KEY (TYP)
);

CREATE TABLE MAGAZYN_OPERACJA (
                ID IDENTITY NOT NULL,
                EWIDENCJA_DPS_ID BIGINT(10),
                MAGAZYN_ID VARCHAR(50) NOT NULL,
                OBIEKT_ID BIGINT(10),
                DATA DATE NOT NULL,
                ILOSC DECIMAL(10,2) NOT NULL,
                TYP VARCHAR(50) NOT NULL,
                CONSTRAINT MAGAZYN_OPERACJA_pk PRIMARY KEY (ID)
);

ALTER TABLE MAGAZYN_OPERACJA ADD CONSTRAINT MAGAZYN_MAGAZYN_OPERACJA_fk
FOREIGN KEY (MAGAZYN_ID)
REFERENCES MAGAZYN (TYP)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE MAGAZYN_OPERACJA ADD CONSTRAINT EWIDENCJA_DPS_MAGAZYN_OPERACJA_fk
FOREIGN KEY (EWIDENCJA_DPS_ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE INDEX MG_TYP_DATA_OPERACJI
    ON MAGAZYN_OPERACJA (MAGAZYN_ID, TYP, DATA);
    
INSERT INTO MAGAZYN(TYP) VALUES('LEKI');

INSERT INTO MAGAZYN(TYP) VALUES('LEKI_DORAZNE');

CREATE TABLE REALIZACJA_RECEPTA_MAGAZYN (
                REALIZACJA_ID BIGINT(10) NOT NULL,
                OPERACJA_ID BIGINT(10) NOT NULL,
                CONSTRAINT REALIZACJA_RECEPTA_MAGAZYN_pk PRIMARY KEY (REALIZACJA_ID, OPERACJA_ID)
);

ALTER TABLE REALIZACJA_RECEPTA_MAGAZYN ADD CONSTRAINT MAGAZYN_OPERACJA_REALIZACJA_MAGAZYN_fk
FOREIGN KEY (OPERACJA_ID)
REFERENCES MAGAZYN_OPERACJA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE REALIZACJA_RECEPTA_MAGAZYN ADD CONSTRAINT REALIZACJA_RECEPTA_REALIZACJA_MAGAZYN_fk
FOREIGN KEY (REALIZACJA_ID)
REFERENCES REALIZACJA_RECEPTA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

--//@UNDO
-- SQL to undo the change goes here.

