--// migracja nieobecnosc informacja.
-- Migration SQL that makes the change goes here.

CREATE TABLE MIEJSCE_POBYTU (
                ID IDENTITY NOT NULL,
                ADRES_ID BIGINT(10),
                NAZWA VARCHAR(150) NOT NULL,
                CONSTRAINT MIEJSCE_POBYTU_pk PRIMARY KEY (ID)
);

CREATE TABLE NIEOBECNOSC_INFORMACJA (
                ID IDENTITY NOT NULL,
                MIEJSCE_ID BIGINT(10) NOT NULL,
                PRACOWNIK_PRZYJAL_ID BIGINT(10),
                PRACOWNIK_SKIEROWAL_ID BIGINT(10) NOT NULL,
                PRACOWNIK_WPROWADZIL_ID BIGINT(10) NOT NULL,
                DATA_WYJAZDU DATE NOT NULL,
                DATA_POWROTU DATE,
                CONSTRAINT NIEOBECNOSC_INFORMACJA_pk PRIMARY KEY (ID)
);

ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT EWIDENCJA_DPS_NIEOBECNOSC_INFORMACJA_fk
FOREIGN KEY (ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE MIEJSCE_POBYTU ADD CONSTRAINT ADRES_MIEJSCE_POBYTU_fk
FOREIGN KEY (ADRES_ID)
REFERENCES ADRES (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT MIEJSCE_POBYTU_NIEOBECNOSC_INFORMACJA_fk
FOREIGN KEY (MIEJSCE_ID)
REFERENCES MIEJSCE_POBYTU (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT PRACOWNIK_SKIEROWAL_INFORMACJA_fk
FOREIGN KEY (PRACOWNIK_SKIEROWAL_ID)
REFERENCES PRACOWNIK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT PRACOWNIK_PRZYJAL_INFORMACJA_fk
FOREIGN KEY (PRACOWNIK_PRZYJAL_ID)
REFERENCES PRACOWNIK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE NIEOBECNOSC_INFORMACJA ADD CONSTRAINT PRACOWNIK_WPROWADZIL_INFORMACJA_fk
FOREIGN KEY (PRACOWNIK_WPROWADZIL_ID)
REFERENCES PRACOWNIK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE UNIQUE INDEX PR_UNIKALNA_NAZWA_MIEJSCE_POBYTU
    ON MIEJSCE_POBYTU (NAZWA);

--//@UNDO
-- SQL to undo the change goes here.

