--// migracja monitorowanie osob.
-- Migration SQL that makes the change goes here.

CREATE AGGREGATE IF NOT EXISTS NOT_NULL_GROUP FOR "org.h2.function.NotNullGroupFunction";

ALTER TABLE POLE_SLOWNIK DROP CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_SLOWNIK_fk;
ALTER TABLE POLE_SLOWNIK DROP CONSTRAINT SLOWO_POLE_SLOWNIK_fk;
ALTER TABLE POLE_SLOWNIK DROP CONSTRAINT POLE_SLOWNIK_pk;
ALTER TABLE POLE_SLOWNIK RENAME TO POLE_SLOWNIK_TMP;
CREATE TABLE POLE_SLOWNIK (
    ID BIGINT(10) NOT NULL,
    WARTOSC BIGINT(7) NOT NULL,
    CONSTRAINT POLE_SLOWNIK_pk PRIMARY KEY (ID, WARTOSC)
) AS SELECT ID, WARTOSC FROM POLE_SLOWNIK_TMP;
ALTER TABLE POLE_SLOWNIK ADD CONSTRAINT SLOWO_POLE_SLOWNIK_fk
  FOREIGN KEY (WARTOSC)
  REFERENCES SLOWO (ID)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
ALTER TABLE POLE_SLOWNIK ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_SLOWNIK_fk
  FOREIGN KEY (ID)
  REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
  ON DELETE CASCADE
  ON UPDATE NO ACTION;
DROP TABLE POLE_SLOWNIK_TMP;

INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
  VALUES ('__monitorowanie_osob', 'DEFINICJA_ZABLOKOWANA', FALSE, 'MONITOROWANIE_OSOB');
  -- data od
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'MONITOROWANIE_OSOB' LIMIT 1),
  null, 1, 'data od', 'DATA', TRUE, null);
  -- data do
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'MONITOROWANIE_OSOB' LIMIT 1),
  null, 2, 'data do', 'DATA', FALSE, null);
  -- obiekt monitorowania
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'MONITOROWANIE_OSOB' LIMIT 1),
  null, 3, 'obiekt monitorowania', 'SLOWNIK_MULTI', TRUE, 'KOD_OBIEKTU_MONITOROWANIA');
  -- uwagi
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'MONITOROWANIE_OSOB' LIMIT 1),
  null, 4, 'uwagi', 'TEKST_DLUGI', FALSE, null);

INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_OBIEKTU_MONITOROWANIA');

--//@UNDO
-- SQL to undo the change goes here.

