--// migracja diagnoza mieszkanca.
-- Migration SQL that makes the change goes here.

INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_RODZAJU_DIAGNOZY');

ALTER TABLE OCENA_KRYTERIUM ADD UWAGI LONGVARCHAR;

CREATE TABLE DIAGNOZA (
                ID IDENTITY NOT NULL,
                SLOWO_ID BIGINT(10) NOT NULL,
                STATUS VARCHAR(50) NOT NULL,
                CONSTRAINT DIAGNOZA_pk PRIMARY KEY (ID)
);

CREATE TABLE DIAGNOZA_INFORMACJA_DODATKOWA (
                DIAGNOZA_ID BIGINT(10) NOT NULL,
                INFORMACJA_ID BIGINT(10) NOT NULL,
                KOLEJNOSC INTEGER,
                CONSTRAINT DIAGNOZA_INFORMACJA_DODATKOWA_pk PRIMARY KEY (DIAGNOZA_ID, INFORMACJA_ID)
);

CREATE TABLE DIAGNOZA_REALIZACJA (
                ID IDENTITY NOT NULL,
                DIAGNOZA_ID BIGINT(10) NOT NULL,
                EWIDENCJA_DPS_ID BIGINT(10) NOT NULL,
                CZY_WSTEPNA BOOLEAN,
                DATA DATE NOT NULL,
                CONSTRAINT DIAGNOZA_REALIZACJA_pk PRIMARY KEY (ID)
);

CREATE TABLE DIAGNOZA_REAL_INFORMACJA (
                INFORMACJA_ID BIGINT(10) NOT NULL,
                DIAGNOZA_REAL_ID BIGINT(10) NOT NULL,
                PRACOWNIK_WYKONAL_ID BIGINT(10) NOT NULL,
                CONSTRAINT DIAGNOZA_REAL_INFORMACJA_pk PRIMARY KEY (INFORMACJA_ID, DIAGNOZA_REAL_ID)
);

CREATE TABLE DIAGNOZA_REAL_OCENA (
                DIAGNOZA_REAL_ID BIGINT(10) NOT NULL,
                OCENA_OSOBY_ID BIGINT(10) NOT NULL,
                PRACOWNIK_WYKONAL_ID BIGINT(10) NOT NULL,
                CONSTRAINT DIAGNOZA_REAL_OCENA_pk PRIMARY KEY (DIAGNOZA_REAL_ID, OCENA_OSOBY_ID)
);

CREATE TABLE DIAGNOZA_SKALA_OCENY (
                SKALA_OCENY_ID BIGINT(10) NOT NULL,
                DIAGNOZA_ID BIGINT(10) NOT NULL,
                KOLEJNOSC INTEGER,
                CONSTRAINT DIAGNOZA_SKALA_OCENY_pk PRIMARY KEY (SKALA_OCENY_ID, DIAGNOZA_ID)
);

CREATE TABLE DIAGNOZA_GRUPA_OSOB (
                ID IDENTITY NOT NULL,
                SKALA_OCENY_ID BIGINT(10) NOT NULL,
                OZNACZENIE VARCHAR(50) NOT NULL,
                OPIS LONGVARCHAR,
                ZAKRES_OD INTEGER,
                ZAKRES_DO INTEGER,
                CONSTRAINT DIAGNOZA_GRUPA_OSOB_pk PRIMARY KEY (ID)
);

CREATE TABLE DIAGNOZA_GR_OS_PLAN_WSPARCIA (
                GRUPA_OSOB_ID BIGINT(10) NOT NULL,
                CZYNNOSC_ID BIGINT(7) NOT NULL,
                CONSTRAINT DIAGNOZA_GR_OS_PLAN_WSPARCIA_pk PRIMARY KEY (GRUPA_OSOB_ID, CZYNNOSC_ID)
);

ALTER TABLE DIAGNOZA_REAL_OCENA ADD CONSTRAINT OCENA_OSOBY_DIAGNOZA_REAL_OCENA_fk
FOREIGN KEY (OCENA_OSOBY_ID)
REFERENCES OCENA_OSOBY (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_REAL_INFORMACJA ADD CONSTRAINT INFORMACJA_DODATKOWA_WPIS_DIAGNOZA_REAL_INFORMACJA_fk
FOREIGN KEY (INFORMACJA_ID)
REFERENCES INFORMACJA_DODATKOWA_WPIS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_INFORMACJA_DODATKOWA ADD CONSTRAINT INFORMACJA_DODATKOWA_DIAGNOZA_INFORMACJA_DODATKOWA_fk
FOREIGN KEY (INFORMACJA_ID)
REFERENCES INFORMACJA_DODATKOWA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_REALIZACJA ADD CONSTRAINT EWIDENCJA_DPS_DIAGNOZA_REALIZACJA_fk
FOREIGN KEY (EWIDENCJA_DPS_ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA ADD CONSTRAINT SLOWO_DIAGNOZA_fk
FOREIGN KEY (SLOWO_ID)
REFERENCES SLOWO (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_REALIZACJA ADD CONSTRAINT DIAGNOZA_DIAGNOZA_REALIZACJA_fk
FOREIGN KEY (DIAGNOZA_ID)
REFERENCES DIAGNOZA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_SKALA_OCENY ADD CONSTRAINT DIAGNOZA_DIAGNOZA_SKALA_OCENY_fk
FOREIGN KEY (DIAGNOZA_ID)
REFERENCES DIAGNOZA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_INFORMACJA_DODATKOWA ADD CONSTRAINT DIAGNOZA_DIAGNOZA_INFORMACJA_DODATKOWA_fk
FOREIGN KEY (DIAGNOZA_ID)
REFERENCES DIAGNOZA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_REAL_OCENA ADD CONSTRAINT DIAGNOZA_REALIZACJA_DIAGNOZA_REAL_OCENA_fk
FOREIGN KEY (DIAGNOZA_REAL_ID)
REFERENCES DIAGNOZA_REALIZACJA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_REAL_INFORMACJA ADD CONSTRAINT DIAGNOZA_REALIZACJA_DIAGNOZA_REAL_INFORMACJA_fk
FOREIGN KEY (DIAGNOZA_REAL_ID)
REFERENCES DIAGNOZA_REALIZACJA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_REAL_OCENA ADD CONSTRAINT PRACOWNIK_DIAGNOZA_REAL_OCENA_fk
FOREIGN KEY (PRACOWNIK_WYKONAL_ID)
REFERENCES PRACOWNIK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_REAL_INFORMACJA ADD CONSTRAINT PRACOWNIK_DIAGNOZA_REAL_INFORMACJA_fk
FOREIGN KEY (PRACOWNIK_WYKONAL_ID)
REFERENCES PRACOWNIK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_GRUPA_OSOB ADD CONSTRAINT SKALA_OCENY_OSOBY_KAT_USL_GRUPA_OSOB_fk
FOREIGN KEY (SKALA_OCENY_ID)
REFERENCES SKALA_OCENY_OSOBY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_SKALA_OCENY ADD CONSTRAINT SKALA_OCENY_OSOBY_DIAGNOZA_SKALA_OCENY_fk
FOREIGN KEY (SKALA_OCENY_ID)
REFERENCES SKALA_OCENY_OSOBY (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_GR_OS_PLAN_WSPARCIA ADD CONSTRAINT KAT_USL_GRUPA_OSOB_KAT_USL_GR_OS_PLAN_WSPARCIA_fk
FOREIGN KEY (GRUPA_OSOB_ID)
REFERENCES DIAGNOZA_GRUPA_OSOB (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DIAGNOZA_GR_OS_PLAN_WSPARCIA ADD CONSTRAINT KAT_USL_CZYNNOSC_KAT_USL_GR_OS_PLAN_WSPARCIA_fk
FOREIGN KEY (CZYNNOSC_ID)
REFERENCES KAT_USL_CZYNNOSC (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

--//@UNDO
-- SQL to undo the change goes here.

