--// migracja zebrania ZTO.
-- Migration SQL that makes the change goes here.

ALTER TABLE PLAN_WSPARCIA_MIESZKANCA ADD PRACOWNIK_PWK_ID BIGINT(10);
ALTER TABLE PLAN_WSPARCIA_MIESZKANCA ADD DATA_ZATWIERDZENIA DATE;
ALTER TABLE PLAN_WSPARCIA_MIESZKANCA ADD NR VARCHAR(10);
UPDATE PLAN_WSPARCIA_MIESZKANCA SET NR = '' WHERE NR IS NULL AND PLAN_AKTUALIZOWANY_ID IS NULL;

ALTER TABLE PLAN_WSPARCIA_MIESZKANCA ADD CONSTRAINT PRACOWNIK_PLAN_WSPARCIA_MIESZKANCA_fk
	FOREIGN KEY (PRACOWNIK_PWK_ID)
	REFERENCES PRACOWNIK (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE AUTONUMER ALTER COLUMN FORMAT VARCHAR(200);
INSERT INTO AUTONUMER (TYP, FORMAT, WARTOSC) VALUES ('PLAN_WSPARCIA', '${nr}/${ewidencja.numerEwidencyjny}/${formatDate(ewidencja.dataOd, ''yyyy'')}/${formatDate((planPierwotny.dataOd)!aktualnaData, ''yyyy'')}', 1);

ALTER TABLE PLAN_WSPARCIA_MIESZKANCA ALTER COLUMN NR VARCHAR(50);


CREATE TABLE ZEBRANIE_ZTO (
                ID IDENTITY NOT NULL,
                SZABLON_WYDRUKU_ID BIGINT(10),
                DATA DATE,
                DATA_PLAN DATE,
                GODZINA_PLAN VARCHAR(5),
                MIEJSCE_PLAN VARCHAR(200),
                CONSTRAINT ZEBRANIE_ZTO_pk PRIMARY KEY (ID)
);

CREATE TABLE ZEBRANIE_ZTO_PRACOWNIK (
                ZEBRANIE_ZTO_ID BIGINT(10) NOT NULL,
                PRACOWNIK_ID BIGINT(10) NOT NULL,
                TYP VARCHAR(50) NOT NULL,
                CONSTRAINT ZEBRANIE_ZTO_PRACOWNIK_pk PRIMARY KEY (ZEBRANIE_ZTO_ID, PRACOWNIK_ID, TYP)
);

CREATE TABLE ZEBRANIE_ZTO_PLAN (
                EWIDENCJA_ID BIGINT(10) NOT NULL,
                ZEBRANIE_ZTO_ID BIGINT(10) NOT NULL,
                CONSTRAINT ZEBRANIE_ZTO_PLAN_pk PRIMARY KEY (EWIDENCJA_ID, ZEBRANIE_ZTO_ID)
);

-- Comment for table [ZEBRANIE_ZTO_PLAN]: dla kogo planuje się utworzenie bądź aktualizację planu wsparcia;


CREATE TABLE ZEBRANIE_ZTO_WYKONANO (
                PLAN_WSPARCIA_ID BIGINT(10) NOT NULL,
                ZEBRANIE_ZTO_ID BIGINT(10) NOT NULL,
                CONSTRAINT ZEBRANIE_ZTO_WYKONANO_pk PRIMARY KEY (PLAN_WSPARCIA_ID, ZEBRANIE_ZTO_ID)
);

-- Comment for table [ZEBRANIE_ZTO_WYKONANO]: wykonany plan wsparcia;


ALTER TABLE ZEBRANIE_ZTO ADD CONSTRAINT SZABLON_WYDRUKU_ZEBRANIE_ZTO_fk
FOREIGN KEY (SZABLON_WYDRUKU_ID)
REFERENCES SZABLON_WYDRUKU (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ZEBRANIE_ZTO_PRACOWNIK ADD CONSTRAINT PRACOWNIK_ZEBRANIE_ZTO_PRACOWNIK_fk
FOREIGN KEY (PRACOWNIK_ID)
REFERENCES PRACOWNIK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ZEBRANIE_ZTO_PLAN ADD CONSTRAINT EWIDENCJA_DPS_ZEBRANIE_ZTO_PLAN_fk
FOREIGN KEY (EWIDENCJA_ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ZEBRANIE_ZTO_PLAN ADD CONSTRAINT ZEBRANIE_ZTO_ZEBRANIE_ZTO_PLAN_fk
FOREIGN KEY (ZEBRANIE_ZTO_ID)
REFERENCES ZEBRANIE_ZTO (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZEBRANIE_ZTO_PRACOWNIK ADD CONSTRAINT ZEBRANIE_ZTO_ZEBRANIE_ZTO_PRACOWNIK_fk
FOREIGN KEY (ZEBRANIE_ZTO_ID)
REFERENCES ZEBRANIE_ZTO (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZEBRANIE_ZTO_WYKONANO ADD CONSTRAINT ZEBRANIE_ZTO_ZEBRANIE_ZTO_WYKONANO_fk
FOREIGN KEY (ZEBRANIE_ZTO_ID)
REFERENCES ZEBRANIE_ZTO (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE ZEBRANIE_ZTO_WYKONANO ADD CONSTRAINT PLAN_WSPARCIA_MIESZKANCA_ZEBRANIE_ZTO_WYKONANO_fk
FOREIGN KEY (PLAN_WSPARCIA_ID)
REFERENCES PLAN_WSPARCIA_MIESZKANCA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

--//@UNDO
-- SQL to undo the change goes here.

