--// migracja na Quartz 2.
-- Migration SQL that makes the change goes here.

--
-- drop tables that are no longer used
--
drop table qrtz_job_listeners;
drop table qrtz_trigger_listeners;
--
-- drop columns that are no longer used
--
alter table qrtz_job_details drop column is_volatile;
alter table qrtz_triggers drop column is_volatile;
alter table qrtz_fired_triggers drop column is_volatile;
--
-- add new columns that replace the 'is_stateful' column
--
alter table qrtz_job_details add column is_nonconcurrent bool;
alter table qrtz_job_details add column IS_UPDATE_DATA bool;
update qrtz_job_details set is_nonconcurrent = is_stateful;
update qrtz_job_details set IS_UPDATE_DATA = is_stateful;
alter table qrtz_job_details drop column is_stateful;
alter table qrtz_fired_triggers add column is_nonconcurrent bool;
alter table qrtz_fired_triggers add column IS_UPDATE_DATA bool;
update qrtz_fired_triggers set is_nonconcurrent = is_stateful;
update qrtz_fired_triggers set IS_UPDATE_DATA = is_stateful;
alter table qrtz_fired_triggers drop column is_stateful;
--
-- add new 'sched_name' column to all tables
--
alter table qrtz_blob_triggers add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_calendars add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_cron_triggers add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_fired_triggers add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_job_details add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_locks add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_paused_trigger_grps add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_scheduler_state add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_simple_triggers add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
alter table qrtz_triggers add column sched_name varchar(120) not null DEFAULT 'QuartzServer';
--
-- drop all primary and foreign key constraints, so that we can define new ones
--
ALTER TABLE QRTZ_CRON_TRIGGERS DROP CONSTRAINT FK_QRTZ_CRON_TRIGGERS_QRTZ_TRIGGERS;
ALTER TABLE QRTZ_TRIGGERS DROP CONSTRAINT FK_QRTZ_TRIGGERS_QRTZ_JOB_DETAILS;
ALTER TABLE QRTZ_SIMPLE_TRIGGERS DROP CONSTRAINT PK_QRTZ_SIMPLE_TRIGGERS;
ALTER TABLE QRTZ_FIRED_TRIGGERS DROP CONSTRAINT PK_QRTZ_FIRED_TRIGGERS;
ALTER TABLE QRTZ_SCHEDULER_STATE DROP CONSTRAINT PK_QRTZ_SCHEDULER_STATE;
ALTER TABLE QRTZ_JOB_DETAILS DROP CONSTRAINT PK_QRTZ_JOB_DETAILS;
ALTER TABLE QRTZ_CRON_TRIGGERS DROP CONSTRAINT PK_QRTZ_CRON_TRIGGERS;
ALTER TABLE QRTZ_PAUSED_TRIGGER_GRPS DROP CONSTRAINT PK_QRTZ_PAUSED_TRIGGER_GRPS;
ALTER TABLE QRTZ_LOCKS DROP CONSTRAINT PK_QRTZ_LOCKS;
ALTER TABLE QRTZ_CALENDARS DROP CONSTRAINT PK_QRTZ_CALENDARS;
ALTER TABLE QRTZ_TRIGGERS DROP CONSTRAINT PK_QRTZ_TRIGGERS;
ALTER TABLE QRTZ_SIMPLE_TRIGGERS DROP CONSTRAINT FK_QRTZ_SIMPLE_TRIGGERS_QRTZ_TRIGGERS;
--
-- add all primary and foreign key constraints, based on new columns
--
alter table qrtz_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table qrtz_triggers add foreign key (sched_name, job_name, job_group) references qrtz_job_details(sched_name, job_name, job_group);
alter table qrtz_blob_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table qrtz_blob_triggers add foreign key (sched_name, trigger_name, trigger_group) references qrtz_triggers(sched_name, trigger_name, trigger_group);
alter table qrtz_cron_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table qrtz_cron_triggers add foreign key (sched_name, trigger_name, trigger_group) references qrtz_triggers(sched_name, trigger_name, trigger_group);
alter table qrtz_simple_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table qrtz_simple_triggers add foreign key (sched_name, trigger_name, trigger_group) references qrtz_triggers(sched_name, trigger_name, trigger_group);
alter table qrtz_fired_triggers add primary key (sched_name, entry_id);
alter table qrtz_calendars add primary key (sched_name, calendar_name);
alter table qrtz_locks add primary key (sched_name, lock_name);
alter table qrtz_paused_trigger_grps add primary key (sched_name, trigger_group);
alter table qrtz_scheduler_state add primary key (sched_name, instance_name);
--
-- add new simprop_triggers table
--
CREATE TABLE qrtz_simprop_triggers
 (          
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512) NULL,
    STR_PROP_2 VARCHAR(512) NULL,
    STR_PROP_3 VARCHAR(512) NULL,
    INT_PROP_1 INT NULL,
    INT_PROP_2 INT NULL,
    LONG_PROP_1 BIGINT NULL,
    LONG_PROP_2 BIGINT NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 BOOL NULL,
    BOOL_PROP_2 BOOL NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
    REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);
--
-- create indexes for faster queries
--
DROP index idx_qrtz_t_next_fire_time;
DROP index idx_qrtz_t_state;
DROP index idx_qrtz_t_nf_st;
DROP index idx_qrtz_ft_trig_group;
DROP index idx_qrtz_ft_trig_name;
DROP index idx_qrtz_ft_trig_n_g;
DROP index idx_qrtz_ft_trig_inst_name;
DROP index idx_qrtz_ft_job_name;
DROP index idx_qrtz_ft_job_group;
create index idx_qrtz_j_req_recovery on qrtz_job_details(SCHED_NAME,REQUESTS_RECOVERY);
create index idx_qrtz_j_grp on qrtz_job_details(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_t_j on qrtz_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_qrtz_t_jg on qrtz_triggers(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_t_c on qrtz_triggers(SCHED_NAME,CALENDAR_NAME);
create index idx_qrtz_t_g on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP);
create index idx_qrtz_t_state on qrtz_triggers(SCHED_NAME,TRIGGER_STATE);
create index idx_qrtz_t_n_state on qrtz_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_t_n_g_state on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_t_next_fire_time on qrtz_triggers(SCHED_NAME,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_st on qrtz_triggers(SCHED_NAME,TRIGGER_STATE,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_st_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE);
create index idx_qrtz_t_nft_st_misfire_grp on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_ft_trig_inst_name on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME);
create index idx_qrtz_ft_inst_job_req_rcvry on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY);
create index idx_qrtz_ft_j_g on qrtz_fired_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_qrtz_ft_jg on qrtz_fired_triggers(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_ft_t_g on qrtz_fired_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP);
create index idx_qrtz_ft_tg on qrtz_fired_triggers(SCHED_NAME,TRIGGER_GROUP);

--//@UNDO
-- SQL to undo the change goes here.

