--// migracja budynkow w ewidencji.
-- Migration SQL that makes the change goes here.

-- usuwanie nieaktualnych indeksów
DROP INDEX EW_UNIKALNY_ID_POKOJU;
DROP INDEX EW_NR_POKOJU;

-- wprowadzanie oznaczenia budynku do ewidencji pokoju
ALTER TABLE DPS_JEDNOSTKA_POKOJ ADD BUDYNEK VARCHAR(50);

-- tworzenie nowych indeksów dla ewidencji pokoi w DPSie
CREATE UNIQUE INDEX EW_UNIKALNY_ID_POKOJU
	ON DPS_JEDNOSTKA_POKOJ (BUDYNEK,PIETRO, NR);
	
-- aktualizacja kolumn dla widoku
DROP VIEW AKTUALNE_POKOJE_MIESZKANCOW;
CREATE VIEW AKTUALNE_POKOJE_MIESZKANCOW AS
	SELECT ewDps.OSOBA_ID as MIESZKANIEC_ID, ewPok.*
	FROM EWIDENCJA_DPS ewDps
		JOIN EWIDENCJA_POKOJE ewPok ON ewDps.ID = ewPok.EWIDENCJA_DPS_ID
			AND ewDps.TYP = 'MIESZKANIEC' AND ewDps.DATA_DO IS NULL -- tylko widok pokoi aktualnych mieszkańców DPS
		LEFT OUTER JOIN EWIDENCJA_POKOJE nEwPok ON ewPok.ID = nEwPok.POPRZEDNI_POKOJ_ID
	WHERE
		nEwPok.ID IS NULL;

--//@UNDO
-- SQL to undo the change goes here.

