--// migracja godziny dyzur pielegniarski cd.
-- Migration SQL that makes the change goes here.

-- kwota główna w umowach z apteką
UPDATE SLOWO 
	SET
		WART_STRING = STRINGDECODE('kwota g\u0142\u00F3wna')
WHERE
	SLOWNIK_ID = (SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_KWOTY_UMOWA_APTEKA')
	AND
	KOD = '001';

-- zmiany w tętno
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		NAZWA = STRINGDECODE('t\u0119tno')
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_CISNIENIA' LIMIT 1)
		AND
		KOLEJNOSC = 5;

-- zmiany w odwiedzinach mieszkańca
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		WYMAGANE = FALSE
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ODWIEDZINY' LIMIT 1)
		AND
		NAZWA = 'godzina';

-- zmiany w definicji pomiarów temperatur ciała
	-- wynik jako 4 pole
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		KOLEJNOSC = 4
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_TEMPERATURY' LIMIT 1)
		AND
		KOLEJNOSC = 3;
	-- godzina jako 3 pole nieobowiązkowe
UPDATE INFORMACJA_DODATKOWA_POLE
	SET
		KOLEJNOSC = 3,
		WYMAGANE = FALSE
	WHERE
		INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_TEMPERATURY' LIMIT 1)
		AND
		KOLEJNOSC = 2;
	-- wprowadzenie dodatkowej informacji o dyżurze pielęgniarskim
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_TEMPERATURY' LIMIT 1),
	null, 2, STRINGDECODE('dotyczy dy\u017Curu piel.'), 'SLOWNIK', FALSE, 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO');

-- zmiany w pomiarach temparatury ciała
	-- wstawianie wpisu dot. pola dyżuru
INSERT INTO INFORMACJA_DODATKOWA_POLE_WPIS(INFORMACJA_WPIS_ID, POLE_ID)
	SELECT iw.ID as INFORMACJA_WPIS_ID, ip.ID as POLE_ID
	FROM INFORMACJA_DODATKOWA_WPIS iw
		JOIN infoRMACJA_DODATKOWA i ON iw.INFORMACJA_DODATKOWA_ID = i.ID 
			AND i.TYP='POMIAR_TEMPERATURY'
	 	JOIN INFORMACJA_DODATKOWA_POLE ip ON i.ID = ip.INFORMACJA_DODATKOWA_ID
	 		AND ip.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.');
	-- wstawianie informacji nt. rodzaju dyżuru
INSERT INTO POLE_SLOWNIK(ID, WARTOSC)
	SELECT (
			SELECT idpwrdz.ID
			FROM INFORMACJA_DODATKOWA_POLE_WPIS idpwrdz
				JOIN INFORMACJA_DODATKOWA_POLE idprdz ON idpwrdz.POLE_ID = idprdz.ID
					AND idpwrdz.INFORMACJA_WPIS_ID = idpw.INFORMACJA_WPIS_ID
					AND idprdz.INFORMACJA_DODATKOWA_ID = idp.INFORMACJA_DODATKOWA_ID
					AND idprdz.NAZWA = STRINGDECODE('dotyczy dy\u017Curu piel.')
		) as ID,
		(
			CASE WHEN pli.WARTOSC < (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_DZIENNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))))
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '002')
				WHEN pli.WARTOSC > (SELECT param.WARTOSC_I FROM PARAMETR_SYSTEMOWY param WHERE param.TYP = 'GODZINA_DYZUR_NOCNY' AND ((param.data_od <= '2011-11-21' AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL)) OR (param.data_od IS NULL AND (param.data_do >= '2011-11-21' OR param.data_do IS NULL))))
					THEN (SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '003')
				ELSE
					(SELECT s.ID FROM SLOWO s JOIN SLOWNIK sl ON s.SLOWNIK_ID = sl.ID AND sl.NAZWA = 'KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO' AND s.KOD = '001')
				END
		) as WARTOSC
	FROM INFORMACJA_DODATKOWA_POLE_WPIS idpw
		JOIN INFORMACJA_DODATKOWA_POLE idp ON idpw.POLE_ID = idp.ID
			AND idp.NAZWA = 'godzina'
		JOIN INFORMACJA_DODATKOWA id ON idp.INFORMACJA_DODATKOWA_ID = id.ID
			AND id.TYP = 'POMIAR_TEMPERATURY'
		JOIN POLE_LICZBA_I pli ON idpw.ID = pli.ID
;
		

--//@UNDO
-- SQL to undo the change goes here.

