--// migracja identyfikacja lekow.
-- Migration SQL that makes the change goes here.

DROP INDEX IF EXISTS LK_NAZWA_LEKU;
ALTER TABLE LEK ADD DAWKA VARCHAR(42);
ALTER TABLE LEK_POSTAC DROP COLUMN DAWKA;

-- update dawek leków (pierwsza z brzegu - najmniejsza (domyślnie wybierana dotychczas))
UPDATE LEK l
	SET l.DAWKA = (
		SELECT bl.DAWKA
		FROM BAZYL_LEK bl
		WHERE
			bl.NAZWA = l.NAZWA
			AND bl.OPAKOWANIE_JEDNOSTKA_POJEMNOSCI = l.OPAKOWANIE_JEDNOSTKA_POJEMNOSCI
			AND bl.POSTAC = l.POSTAC
		ORDER BY bl.DAWKA
		LIMIT 1
	);

	-- wstawianie pozostałych dawek leku
INSERT INTO LEK(NAZWA, OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC, DAWKA)
	SELECT DISTINCT bl.NAZWA, bl.OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, bl.POSTAC, bl.DAWKA
	FROM BAZYL_LEK bl
		JOIN BAZYL_LEK_POSTAC blp ON bl.ID = blp.LEK_ID
		JOIN LEK_POSTAC lp ON blp.KOD_BAZYL = lp.KOD_BAZYL
		JOIN LEK l ON lp.LEK_ID = l.ID
			AND l.DAWKA != bl.DAWKA;
			
	-- przepisywanie postaci leków wg BAZYLA
UPDATE LEK_POSTAC lp
	SET lp.LEK_ID = (
		SELECT l.ID
		FROM LEK l
			JOIN BAZYL_LEK bl ON  bl.NAZWA = l.NAZWA
				AND bl.OPAKOWANIE_JEDNOSTKA_POJEMNOSCI = l.OPAKOWANIE_JEDNOSTKA_POJEMNOSCI
				AND bl.POSTAC = l.POSTAC
				AND bl.DAWKA = l.DAWKA
			JOIN BAZYL_LEK_POSTAC blp ON bl.ID = blp.LEK_ID
				AND blp.KOD_BAZYL = lp.KOD_BAZYL
		UNION ALL
		SELECT tmpLp.LEK_ID
		FROM LEK_POSTAC tmpLp
		WHERE tmpLp.KOD_BAZYL = lp.KOD_BAZYL
		LIMIT 1
	);
	
-- usuwanie nieużywanych leków ze słownika leków wykorzystywanych
DELETE FROM LEK l
WHERE NOT EXISTS (
	-- leki z dawkowań
	SELECT dl.LEK_ID
	FROM DAWKA_LEK dl
	WHERE dl.LEK_ID = l.ID
	-- leki z indywidualnych podań
	UNION
	SELECT dp.LEK_ID
	FROM DAWKA_PODANIE dp
	WHERE
		dp.LEK_ID = l.ID
	-- leki z realizacji na fakturach
	UNION
	SELECT le.ID as LEK_ID
	FROM LEK le
		JOIN LEK_POSTAC lp ON le.ID = lp.LEK_ID
			AND le.ID = l.ID
		JOIN LEK_REALIZACJA lr ON lp.KOD_BAZYL = lr.KOD_BAZYL
	-- leki z magazynu podręcznego
	UNION
	SELECT mo.OBIEKT_ID as LEK_ID
	FROM MAGAZYN_OPERACJA mo
	WHERE
		mo.MAGAZYN_ID = 'LEKI_DORAZNE'
		AND mo.OBIEKT_ID = l.ID
);

CREATE UNIQUE INDEX LK_NAZWA_LEKU
  ON LEK(NAZWA, OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC, DAWKA);

--//@UNDO
-- SQL to undo the change goes here.

