--// migracja dzienny pobyt.
-- Migration SQL that makes the change goes here.

CREATE TABLE SWIADCZENIE_GRUPA (
                ID IDENTITY NOT NULL,
                NAZWA VARCHAR(100) NOT NULL,
                CONSTRAINT SWIADCZENIE_GRUPA_pk PRIMARY KEY (ID)
);

CREATE TABLE SWIADCZENIE (
                ID IDENTITY NOT NULL,
                GRUPA_ID BIGINT(10) NOT NULL,
                NAZWA VARCHAR(100) NOT NULL,
                JEDNOSTKA VARCHAR(50) NOT NULL,
                SKROT_WYDRUK VARCHAR(10),
                CONSTRAINT SWIADCZENIE_pk PRIMARY KEY (ID)
);

CREATE TABLE SWIADCZENIE_ODPLATNOSC (
                ID IDENTITY NOT NULL,
                SWIADCZENIE_ID BIGINT(10) NOT NULL,
                ROK INTEGER NOT NULL,
                MIESIAC INTEGER,
                KWOTA DECIMAL(10,2) NOT NULL,
                CONSTRAINT SWIADCZENIE_ODPLATNOSC_pk PRIMARY KEY (ID)
);

CREATE TABLE SWIADCZENIE_REALIZACJA (
                SWIADCZENIE_ID BIGINT(10) NOT NULL,
                DATA DATE NOT NULL,
                MIESZKANIEC_ID BIGINT(10) NOT NULL,
                ILOSC DECIMAL(10,2) NOT NULL,
                CONSTRAINT SWIADCZENIE_REALIZACJA_pk PRIMARY KEY (SWIADCZENIE_ID, DATA)
);

CREATE TABLE ROZLICZENIE (
                ID IDENTITY NOT NULL,
                MIESZKANIEC_ID BIGINT(10) NOT NULL,
                ROK INTEGER NOT NULL,
                MIESIAC INTEGER NOT NULL,
                CONSTRAINT ROZLICZENIE_pk PRIMARY KEY (ID)
);

CREATE TABLE ROZLICZENIE_SWIADCZENIE (
                ROZLICZENIE_ID BIGINT(10) NOT NULL,
                SWIADCZENIE_ID BIGINT(10) NOT NULL,
                ILOSC DECIMAL(10,2) NOT NULL,
                CONSTRAINT ROZLICZENIE_SWIADCZENIE_pk PRIMARY KEY (ROZLICZENIE_ID, SWIADCZENIE_ID)
);

CREATE TABLE DECYZJA_DZ_O_ODPLATNOSCI (
                ID IDENTITY NOT NULL,
                MIESZKANIEC_ID BIGINT(10) NOT NULL,
                KTO_WYDAL_ID BIGINT(10) NOT NULL,
                DATA_WYDANIA DATE NOT NULL,
                NR VARCHAR(50) NOT NULL,
                OBOWIAZUJE_OD DATE,
                OBOWIAZUJE_DO DATE,
                CONSTRAINT DECYZJA_DZ_O_ODPLATNOSCI_pk PRIMARY KEY (ID)
);

CREATE TABLE DECYZJA_SWIADCZENIE (
                DECYZJA_ID BIGINT(10) NOT NULL,
                SWIADCZENIE_ID BIGINT(10) NOT NULL,
                ILOSC_LIMIT DECIMAL(10,2) NOT NULL,
                OKRES_ILOSC_LIMIT INTEGER NOT NULL,
                OKRES_LIMIT VARCHAR(50) NOT NULL,
                PROCENT_ODPLATNOSC INTEGER DEFAULT 100 NOT NULL,
                CONSTRAINT DECYZJA_SWIADCZENIE_pk PRIMARY KEY (DECYZJA_ID, SWIADCZENIE_ID)
);

ALTER TABLE SWIADCZENIE ADD CONSTRAINT SWIADCZENIE_GRUPA_SWIADCZENIE_fk
FOREIGN KEY (GRUPA_ID)
REFERENCES SWIADCZENIE_GRUPA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DECYZJA_DZ_O_ODPLATNOSCI ADD CONSTRAINT SLOWO_DECYZJA_DZ_O_ODPLATNOSCI_fk
FOREIGN KEY (KTO_WYDAL_ID)
REFERENCES SLOWO (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SWIADCZENIE_ODPLATNOSC ADD CONSTRAINT SWIADCZENIE_SWIADCZENIE_ODPLATNOSC_fk
FOREIGN KEY (SWIADCZENIE_ID)
REFERENCES SWIADCZENIE (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DECYZJA_SWIADCZENIE ADD CONSTRAINT SWIADCZENIE_DECYZJA_SWIADCZENIE_fk
FOREIGN KEY (SWIADCZENIE_ID)
REFERENCES SWIADCZENIE (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ROZLICZENIE_SWIADCZENIE ADD CONSTRAINT SWIADCZENIE_ROZLICZENIE_SWIADCZENIE_fk
FOREIGN KEY (SWIADCZENIE_ID)
REFERENCES SWIADCZENIE (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SWIADCZENIE_REALIZACJA ADD CONSTRAINT SWIADCZENIE_SWIADCZENIE_REALIZACJA_fk
FOREIGN KEY (SWIADCZENIE_ID)
REFERENCES SWIADCZENIE (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DECYZJA_DZ_O_ODPLATNOSCI ADD CONSTRAINT OSOBA_DECYZJA_DZ_O_ODPLATNOSCI_fk
FOREIGN KEY (MIESZKANIEC_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ROZLICZENIE ADD CONSTRAINT OSOBA_ROZLICZENIE_fk
FOREIGN KEY (MIESZKANIEC_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SWIADCZENIE_REALIZACJA ADD CONSTRAINT OSOBA_SWIADCZENIE_REALIZACJA_fk
FOREIGN KEY (MIESZKANIEC_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE ROZLICZENIE_SWIADCZENIE ADD CONSTRAINT ROZLICZENIE_ROZLICZENIE_SWIADCZENIE_fk
FOREIGN KEY (ROZLICZENIE_ID)
REFERENCES ROZLICZENIE (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DECYZJA_SWIADCZENIE ADD CONSTRAINT DECYZJA_DZ_O_ODPLATNOSCI_DECYZJA_SWIADCZENIE_fk
FOREIGN KEY (DECYZJA_ID)
REFERENCES DECYZJA_DZ_O_ODPLATNOSCI (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

--//@UNDO
-- SQL to undo the change goes here.

