--// migracja lekarz zalecenia.
-- Migration SQL that makes the change goes here.

-- nowy słownik lekarzy pracujących z mieszkańcami
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_LEKARZA');

-- zmiany we wprowadzonych danych
	-- wprowadzanie słów do słownika lekarzy
INSERT INTO SLOWO(SLOWNIK_ID, WART_STRING, KOD)
	SELECT
		(SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_LEKARZA') as SLOWNIK_ID,
		CONCAT(p.NAZWISKO, ' ', p.IMIE) as WART_STRING,
		LPAD(CAST(ROWNUM() as VARCHAR), 3, '0') as KOD
	FROM PRACOWNIK p
		JOIN (
			SELECT
				DISTINCT (pp.WARTOSC) as PRACOWNIK_ID
			FROM INFORMACJA_DODATKOWA i
				JOIN INFORMACJA_DODATKOWA_POLE idp ON i.ID = idp.INFORMACJA_DODATKOWA_ID
					AND i.NAZWA = '__zalecenie_lekarskie'
				JOIN INFORMACJA_DODATKOWA_POLE_WPIS idpw ON idp.ID = idpw.POLE_ID
				JOIN POLE_PRACOWNIK pp ON idpw.ID = pp.ID
		) as tmp ON p.ID = tmp.PRACOWNIK_ID;
		
	-- wstawianie powiązania lekarzy z zaleceniami w inne pole informacji dodatkowej
INSERT INTO POLE_SLOWNIK(ID, WARTOSC)
	SELECT 
		idpw.ID,
		(
			SELECT s.ID
			FROM SLOWO s
			WHERE
				s.SLOWNIK_ID = (SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_LEKARZA')
				AND s.WART_STRING = CONCAT(p.NAZWISKO, ' ', p.IMIE)
		) as WARTOSC
	FROM INFORMACJA_DODATKOWA i
		JOIN INFORMACJA_DODATKOWA_POLE idp ON i.ID = idp.INFORMACJA_DODATKOWA_ID
			AND i.NAZWA = '__zalecenie_lekarskie'
		JOIN INFORMACJA_DODATKOWA_POLE_WPIS idpw ON idp.ID = idpw.POLE_ID
		JOIN POLE_PRACOWNIK pp ON idpw.ID = pp.ID
		JOIN PRACOWNIK p ON pp.WARTOSC = p.ID;
		
	-- usuwanie wpisów z pola pracownik
DELETE FROM POLE_PRACOWNIK pp
WHERE pp.ID IN (
	SELECT idpw.ID
	FROM INFORMACJA_DODATKOWA i
	JOIN INFORMACJA_DODATKOWA_POLE idp ON i.ID = idp.INFORMACJA_DODATKOWA_ID
		AND i.NAZWA = '__zalecenie_lekarskie'
	JOIN INFORMACJA_DODATKOWA_POLE_WPIS idpw ON idp.ID = idpw.POLE_ID
		AND idp.NAZWA = 'lekarz'
);

-- zmiany w definicji
UPDATE INFORMACJA_DODATKOWA_POLE idp
	SET
		idp.TYP = 'SLOWNIK',
		idp.NAZWA_SLOWNIKA = 'KOD_LEKARZA'
	WHERE
		idp.INFORMACJA_DODATKOWA_ID = (SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.NAZWA = '__zalecenie_lekarskie')
		AND idp.NAZWA = 'lekarz';

--//@UNDO
-- SQL to undo the change goes here.

