--// migracja wplaty import CSV.
-- Migration SQL that makes the change goes here.

CREATE TABLE FORMAT_CSV (
    ID IDENTITY NOT NULL,
    CHARSET VARCHAR(50) NOT NULL,
    LINIA_OPISOW BOOLEAN,
    NAZWA VARCHAR(50) NOT NULL,
    SEPARATOR_POLA VARCHAR(1) NOT NULL,
    SEPARATOR_WIERSZA VARCHAR(1) NOT NULL,
    CONSTRAINT FORMAT_CSV_pk PRIMARY KEY (ID)
);

CREATE TABLE PLIK_CSV (
    ID IDENTITY NOT NULL,
    FORMAT_CSV_ID BIGINT(10) NOT NULL,
    PRACOWNIK_ID BIGINT(10) NOT NULL,
    NAZWA VARCHAR(50) NOT NULL,
    MD5SUM VARCHAR(32) NOT NULL,
    DATA DATE NOT NULL,
    CONSTRAINT PLIK_CSV_pk PRIMARY KEY (ID)
);

CREATE TABLE POLE_CSV (
    FORMAT_CSV_ID BIGINT(10) NOT NULL,
    NAZWA VARCHAR(50) NOT NULL,
    KOLEJNOSC INTEGER NOT NULL,
    CONSTRAINT POLE_CSV_pk PRIMARY KEY (FORMAT_CSV_ID, NAZWA)
);

ALTER TABLE PLIK_CSV ADD CONSTRAINT PRACOWNIK_PLIK_CSV_IMPORT_fk
	FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE PLIK_CSV ADD CONSTRAINT CSV_FORMAT_PLIK_CSV_fk
	FOREIGN KEY (FORMAT_CSV_ID)
	REFERENCES FORMAT_CSV (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
ALTER TABLE POLE_CSV ADD CONSTRAINT FORMAT_CSV_POLE_CSV_fk
	FOREIGN KEY (FORMAT_CSV_ID)
	REFERENCES FORMAT_CSV (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	
CREATE TABLE WPLATA_PLIK_POZYCJA (
    POZYCJA_ID BIGINT(10) NOT NULL,
    PLIK_CSV_ID BIGINT(10) NOT NULL,
    WIERSZ INTEGER NOT NULL,
    TRESC LONGVARBINARY NOT NULL,
    CONSTRAINT WPLATA_PLIK_POZYCJA_pk PRIMARY KEY (POZYCJA_ID)
);

ALTER TABLE WPLATA_PLIK_POZYCJA ADD CONSTRAINT PLIK_CSV_WPLATA_PLIK_POZYCJA_fk
	FOREIGN KEY (PLIK_CSV_ID)
	REFERENCES PLIK_CSV (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
ALTER TABLE WPLATA_PLIK_POZYCJA ADD CONSTRAINT WPLATA_WPLATA_PLIK_POZYCJA_fk
	FOREIGN KEY (POZYCJA_ID)
	REFERENCES WPLATA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;


--//@UNDO
-- SQL to undo the change goes here.

