--// migracja konto bankowe zakaz edycji.
-- Migration SQL that makes the change goes here.

-- zmiany w strukturze KONTO_BANKOWE
-- ... użycie
ALTER TABLE KONTO_BANKOWE ADD LICZNIK_UZYCIE INTEGER;
UPDATE KONTO_BANKOWE k SET k.LICZNIK_UZYCIE = (
		SELECT COUNT(nop.ID)
		FROM NOTA_ODPLATNOSC_POZYCJA nop
		WHERE nop.KONTO_ID = k.ID
	);
UPDATE KONTO_BANKOWE SET LICZNIK_UZYCIE = 0 WHERE LICZNIK_UZYCIE IS NULL;
ALTER TABLE KONTO_BANKOWE ALTER COLUMN LICZNIK_UZYCIE SET NOT NULL;
-- ... liczba przypisan
ALTER TABLE KONTO_BANKOWE ADD LICZNIK_PRZYPISAN INTEGER;
UPDATE KONTO_BANKOWE kb SET kb.LICZNIK_PRZYPISAN = (
		SELECT COALESCE(SUM(tmp.LICZNIK_PRZYPISAN), 0)
		FROM KONTO_BANKOWE tmpKb
			JOIN (
				SELECT k.KONTO_ID, SUM(k.LICZBA) as LICZNIK_PRZYPISAN
				FROM (
					SELECT okb.KONTO_ID, COUNT(*) as LICZBA
					FROM OSOBA_KONTO_BANKOWE okb
					GROUP BY okb.KONTO_ID
					
					UNION ALL
					
					SELECT idkb.KONTO_ID, COUNT(*) as LICZBA
					FROM INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE idkb
					GROUP BY idkb.KONTO_ID
					
					UNION ALL
					
					SELECT nop.KONTO_ID, COUNT(*) as LICZBA
					FROM NOTA_ODPLATNOSC_POZYCJA nop
					GROUP BY nop.KONTO_ID
					
					UNION ALL
					
					SELECT djkb.KONTO_ID, COUNT(*) as LICZBA
					FROM DPS_JEDNOSTKA_KONTO_BANKOWE djkb
					GROUP BY djkb.KONTO_ID
				) as k
				GROUP BY k.KONTO_ID
			) as tmp ON tmpKb.ID = tmp.KONTO_ID
				AND tmp.KONTO_ID = kb.ID
	);
UPDATE KONTO_BANKOWE k SET k.LICZNIK_PRZYPISAN = 0 WHERE k.LICZNIK_PRZYPISAN IS NULL;
ALTER TABLE KONTO_BANKOWE ALTER COLUMN LICZNIK_PRZYPISAN SET NOT NULL;


-- triggery utrzymujące spójność
-- ... OSOBA_KONTO_BANKOWE
CREATE TRIGGER AINS_OSOBA_KONTO AFTER
	INSERT ON OSOBA_KONTO_BANKOWE FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterOsobaKontoBankoweInsert";
CREATE TRIGGER ADEL_OSOBA_KONTO AFTER
	DELETE ON OSOBA_KONTO_BANKOWE FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterOsobaKontoBankoweDelete";
-- ... INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE
CREATE TRIGGER AINS_INSTYTUCJA_DOP_KONTO AFTER
	INSERT ON INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterInstytucjaDoplacajacaKontoBankoweInsert";
CREATE TRIGGER ADEL_INSTYTUCJA_DOP_KONTO AFTER
	DELETE ON INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterInstytucjaDoplacajacaKontoBankoweDelete";
-- ... DPS_JEDNOSTKA_KONTO_BANKOWE
CREATE TRIGGER AINS_DPS_JEDNOSTKA_KONTO AFTER
	INSERT ON DPS_JEDNOSTKA_KONTO_BANKOWE FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterDpsJednostkaKontoBankoweInsert";
CREATE TRIGGER ADEL_DPS_JEDNOSTKA_KONTO AFTER
	DELETE ON DPS_JEDNOSTKA_KONTO_BANKOWE FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterDpsJednostkaKontoBankoweDelete";
-- ... NOTA_ODPLATNOSC_POZYCJA
CREATE TRIGGER AINS_NOTA_ODPLATNOSC_POZYCJA_KONTO AFTER
	INSERT ON NOTA_ODPLATNOSC_POZYCJA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterNotaOdplPozycjaKontoBankoweInsert";
CREATE TRIGGER ADEL_NOTA_ODPLATNOSC_POZYCJA_KONTO AFTER
	DELETE ON NOTA_ODPLATNOSC_POZYCJA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.kontoBankowe.AfterNotaOdplPozycjaKontoBankoweDelete";


--//@UNDO
-- SQL to undo the change goes here.

