--// migracja kwoty odpisu not.
-- Migration SQL that makes the change goes here.


-- zmiany w tabelach
ALTER TABLE ZADLUZENIE_WYROWNANIE ADD KWOTA_ODPISU DECIMAL(10,2);
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD KWOTA_ODPISU DECIMAL(10,2);

-- uaktulanienie danych
UPDATE ZADLUZENIE_WYROWNANIE zw
	SET zw.KWOTA_ODPISU = zw.KWOTA
WHERE zw.ID IN (
	SELECT zw.ID
	FROM NOTA_ODPLATNOSC no
		JOIN NOTA_ODPLATNOSC_POZYCJA nop ON nop.NOTA_ID = no.ID
			AND no.TYP = 'ODPISY'
);
UPDATE NOTA_ODPLATNOSC_POZYCJA nop
	SET nop.KWOTA_ODPISU = (
		SELECT SUM(zw.KWOTA_ODPISU)
		FROM ZADLUZENIE_WYROWNANIE zw
		WHERE zw.NOTA_POZYCJA_ID = nop.ID
	);

-- uaktualnianie statusów nieobecności dla odpisów, które są na notach
UPDATE NIEOBECNOSC n
	SET n.STATUS = 'ROZLICZONA'
WHERE
	n.STATUS = 'DO_ROZLICZENIA'
	AND n.ID IN (
		SELECT tmpn.ID
		FROM ZADLUZENIE_WYROWNANIE tmpzw
			JOIN ODPIS_ZWROT tmpoz ON tmpzw.ODPIS_ID = tmpoz.ID
			JOIN NIEOBECNOSC tmpn ON tmpoz.NIEOBECNOSC_ID = n.ID
	);



--//@UNDO
-- SQL to undo the change goes here.

