--// migracja rozliczenie ER zgon.
-- Migration SQL that makes the change goes here.

-- nowe słowniki
INSERT INTO SLOWNIK(NAZWA) VALUES('KOD_USC');
INSERT INTO SLOWNIK(NAZWA) VALUES('KOD_MIEJSCA_ZGONU');
INSERT INTO SLOWNIK(NAZWA) VALUES('KOD_ORGANU_ODP_POGRZEB');

INSERT INTO SLOWO (SLOWNIK_ID, KOLEJNOSC, WART_STRING, KOD) VALUES((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_MIEJSCA_ZGONU'), null, 'DPS', '001');
INSERT INTO SLOWO (SLOWNIK_ID, KOLEJNOSC, WART_STRING, KOD) VALUES((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_MIEJSCA_ZGONU'), null, 'dom rodzinny', '002');
INSERT INTO SLOWO (SLOWNIK_ID, KOLEJNOSC, WART_STRING, KOD) VALUES((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_MIEJSCA_ZGONU'), null, 'szpital', '003');

-- termin wyplaty (ze slownika 	KOD_TERMINU_WYPLATY("Termin wypłaty świadczenia", "kodTerminuWyplatySwiadczeniaSlownik")
CREATE TABLE TERMIN_WYPLATY (
    ID IDENTITY NOT NULL,
    DZIEN INTEGER NOT NULL,
    TEKST VARCHAR(50) NOT NULL,
    CONSTRAINT TERMIN_WYPLATY_pk PRIMARY KEY (ID)
);
	-- przeniesienie danych ze słownika
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('1-go każdego miesiąca', 1);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('2-go każdego miesiąca', 2);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('3-go każdego miesiąca', 3);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('4-go każdego miesiąca', 4);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('5-go każdego miesiąca', 5);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('6-go każdego miesiąca', 6);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('7-go każdego miesiąca', 7);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('8-go każdego miesiąca', 8);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('9-go każdego miesiąca', 9);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('10-go każdego miesiąca', 10);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('11-go każdego miesiąca', 11);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('12-go każdego miesiąca', 12);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('13-go każdego miesiąca', 13);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('14-go każdego miesiąca', 14);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('15-go każdego miesiąca', 15);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('16-go każdego miesiąca', 16);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('17-go każdego miesiąca', 17);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('18-go każdego miesiąca', 18);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('19-go każdego miesiąca', 19);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('20-go każdego miesiąca', 20);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('21-go każdego miesiąca', 21);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('22-go każdego miesiąca', 22);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('23-go każdego miesiąca', 23);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('24-go każdego miesiąca', 24);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('25-go każdego miesiąca', 25);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('26-go każdego miesiąca', 26);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('27-go każdego miesiąca', 27);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('28-go każdego miesiąca', 28);
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN) VALUES('''ostatniego każdego miesiąca''', 0x7fffffff);
	-- inne dodane przez użytkownika (nie domyślne z TT)
INSERT INTO TERMIN_WYPLATY(TEKST, DZIEN)
	SELECT s.WART_STRING, 30
	FROM SLOWNIK sl
		JOIN SLOWO s ON sl.ID = s.SLOWNIK_ID
			AND sl.NAZWA = 'KOD_TERMINU_WYPLATY'
			AND s.WART_STRING NOT IN (
				SELECT t.TEKST
				FROM TERMIN_WYPLATY t
			);
-- pobierane świadczenie
ALTER TABLE POBIERANE_SWIADCZENIE DROP CONSTRAINT IF EXISTS TERM_WYPL_SWIADCZENIA_fk;
ALTER TABLE POBIERANE_SWIADCZENIE ADD TERMIN_ID BIGINT(10);
UPDATE POBIERANE_SWIADCZENIE ps SET ps.TERMIN_ID = (
			SELECT t.ID
			FROM TERMIN_WYPLATY t
			WHERE t.TEKST = (
				SELECT s.WART_STRING
				FROM SLOWO s
				WHERE s.ID = ps.TERMIN_WYPLATY_ID
			)
		)
	WHERE ps.TERMIN_WYPLATY_ID IS NOT NULL;
ALTER TABLE POBIERANE_SWIADCZENIE DROP COLUMN TERMIN_WYPLATY_ID;
ALTER TABLE POBIERANE_SWIADCZENIE ALTER COLUMN TERMIN_ID RENAME TO TERMIN_WYPLATY_ID;
ALTER TABLE POBIERANE_SWIADCZENIE ADD CONSTRAINT TERMIN_WYPLATY_POBIERANE_SWIADCZENIE_fk
	FOREIGN KEY (TERMIN_WYPLATY_ID)
	REFERENCES TERMIN_WYPLATY (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
	-- wpłaty ze świadczeń
ALTER TABLE SWIADCZENIE_WPLATA ADD TERMIN_WYPLATY_ID BIGINT(10);
UPDATE SWIADCZENIE_WPLATA sw SET sw.TERMIN_WYPLATY_ID = (
	SELECT t.ID
	FROM TERMIN_WYPLATY t
	WHERE t.TEKST = (
		SELECT s.WART_STRING
		FROM SLOWO s
		WHERE s.ID = sw.TERMIN_ID
	)
);
ALTER TABLE SWIADCZENIE_WPLATA DROP CONSTRAINT IF EXISTS SLOWO_WPLATA_SWIADCZENIE_fk;
ALTER TABLE SWIADCZENIE_WPLATA ADD CONSTRAINT TERMIN_WYPLATY_WPLATA_SWIADCZENIE_fk
	FOREIGN KEY (TERMIN_WYPLATY_ID)
	REFERENCES TERMIN_WYPLATY (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE SWIADCZENIE_WPLATA DROP COLUMN TERMIN_ID;
ALTER TABLE SWIADCZENIE_WPLATA ALTER COLUMN TERMIN_WYPLATY_ID SET NOT NULL;
	
	-- usuwanie słownika terminów
DELETE FROM SLOWO s WHERE s.SLOWNIK_ID = (SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_TERMINU_WYPLATY');
DELETE FROM SLOWNIK WHERE NAZWA = 'KOD_TERMINU_WYPLATY';

-- ewidencja zgonu
CREATE TABLE EWIDENCJA_DPS_ZGON (
    ID BIGINT(10) NOT NULL,
    USC_ID BIGINT(10),
    MIEJSCE_ZGONU_ID BIGINT(10),
    ODPOWIEDZIALNY_ZA_POGRZEB_ID BIGINT(10),
    GODZINA INTEGER,
    MIEJSCE_POCHOWKU VARCHAR(100),
    NR_AKT_ZGON VARCHAR(25),
    STATUS VARCHAR(50) NOT NULL,
    UWAGI LONGVARCHAR,
    CONSTRAINT EWIDENCJA_DPS_ZGON_pk PRIMARY KEY (ID)
);
ALTER TABLE EWIDENCJA_DPS_ZGON ADD CONSTRAINT SLOWO_EWIDENCJA_DPS_ZGON_USC_fk
	FOREIGN KEY (USC_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE EWIDENCJA_DPS_ZGON ADD CONSTRAINT SLOWO_EWIDENCJA_DPS_ZGON_MIEJSCE_fk
	FOREIGN KEY (MIEJSCE_ZGONU_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE EWIDENCJA_DPS_ZGON ADD CONSTRAINT SLOWO_EWIDENCJA_DPS_ZGON_ODP_POGRZEB_fk
	FOREIGN KEY (ODPOWIEDZIALNY_ZA_POGRZEB_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE EWIDENCJA_DPS_ZGON ADD CONSTRAINT EWIDENCJA_DPS_EWIDENCJA_DPS_ZGON_fk
	FOREIGN KEY (ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;

	-- poprawki danych
INSERT INTO EWIDENCJA_DPS_ZGON(ID, GODZINA, NR_AKT_ZGON, STATUS)
	SELECT ew.ID, ew.GODZINA, ew.NUMER_EWIDENCYJNY, 'ROZLICZONA'
	FROM EWIDENCJA_DPS ew
	WHERE ew.TYP IN ('MIESZKANIEC_ZGON', 'OSOBA_OCZEKUJACA_ZGON');
	
UPDATE EWIDENCJA_DPS ew SET ew.NUMER_EWIDENCYJNY = NULL
	WHERE ew.TYP IN ('MIESZKANIEC_ZGON', 'OSOBA_OCZEKUJACA_ZGON');

-- aktualizacja wpisów ewidencji
DROP VIEW AKTUALNE_DAWKI_LEKOW;
DROP VIEW PRACOWNIK_MIESZKANIEC_CZYNNOSCI;
DROP VIEW AKTUALNE_WPISY_EWIDENCJI_OSOB;

ALTER TABLE EWIDENCJA_DPS DROP COLUMN GODZINA;

CREATE VIEW AKTUALNE_WPISY_EWIDENCJI_OSOB AS
	SELECT ew.*,
		ewZg.USC_ID, ewZg.MIEJSCE_ZGONU_ID, ewZg.ODPOWIEDZIALNY_ZA_POGRZEB_ID, ewZg.MIEJSCE_POCHOWKU, ewZg.NR_AKT_ZGON, ewZg.GODZINA, ewZg.STATUS, ewZg.UWAGI
	FROM EWIDENCJA_DPS ew
		LEFT OUTER JOIN EWIDENCJA_DPS nEw ON nEw.EWID_POPRZEDNI_WPIS_ID = ew.ID
		LEFT OUTER JOIN EWIDENCJA_DPS_ZGON ewZg ON ew.ID = ewZg.ID
	WHERE nEw.ID IS NULL;

CREATE VIEW AKTUALNE_DAWKI_LEKOW AS
	SELECT ewDps.OSOBA_ID, d.*
		FROM AKTUALNE_WPISY_EWIDENCJI_OSOB ewDps
			JOIN DAWKOWANIE d ON d.EWIDENCJA_DPS_ID = ewDps.ID
				AND d.DATA_OD <= CURRENT_DATE()
			LEFT OUTER JOIN DAWKOWANIE najD ON najD.EWIDENCJA_DPS_ID = ewDps.ID
				AND najD.POPRZEDNIE_DAWKOWANIE_ID = d.ID
	WHERE
		najD.ID IS NULL;

CREATE VIEW PRACOWNIK_MIESZKANIEC_CZYNNOSCI AS
	SELECT pr.ID as PRACOWNIK_ID, wpisEwid.OSOBA_ID AS MIESZKANIEC_ID, grUpr.CZYNNOSC_ID, grUpr.TYP_UPRAWNIENIA, plan.DATA_OD, plan.DATA_DO
	FROM AKTUALNE_WPISY_EWIDENCJI_OSOB wpisEwid
		JOIN PLAN_WSPARCIA_MIESZKANCA plan ON wpisEwid.ID = plan.EWIDENCJA_ID
			AND wpisEwid.TYP = 'MIESZKANIEC'
		JOIN PLAN_WSPARCIA_CZYNNOSC planCz ON plan.ID = planCz.PLAN_ID
		JOIN GRUPA_UPRAWNIENIE_KAT_USLUG grUpr ON planCz.CZYNNOSC_ID = grUpr.CZYNNOSC_ID
		JOIN PRACOWNIK pr ON grUpr.GRUPA_ID = pr.GRUPA_ID;

-- swiadczenie zwrot
CREATE TABLE SWIADCZENIE_ZWROT (
    ID IDENTITY NOT NULL,
    EWIDENCJA_ZGON_ID BIGINT(10) NOT NULL,
    INSTYTUCJA_ID BIGINT(10) NOT NULL,
    SWIADCZENIE_ID BIGINT(10) NOT NULL,
    ZADLUZENIE_POZYCJA_ID BIGINT(10) NOT NULL,
    ZWROT_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    CONSTRAINT SWIADCZENIE_ZWROT_pk PRIMARY KEY (ID)
);

ALTER TABLE SWIADCZENIE_ZWROT ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_SWIADCZENIE_ZWROT_fk
FOREIGN KEY (INSTYTUCJA_ID)
REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SWIADCZENIE_ZWROT ADD CONSTRAINT ODPIS_ZWROT_SWIADCZENIE_DO_ZWROTU_fk
FOREIGN KEY (ZWROT_ID)
REFERENCES ODPIS_ZWROT (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SWIADCZENIE_ZWROT ADD CONSTRAINT POBIERANE_SWIADCZENIE_SWIADCZENIE_ZWROT_fk
FOREIGN KEY (SWIADCZENIE_ID)
REFERENCES POBIERANE_SWIADCZENIE (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SWIADCZENIE_ZWROT ADD CONSTRAINT EWIDENCJA_DPS_ZGON_SWIADCZENIE_ZWROT_fk
FOREIGN KEY (EWIDENCJA_ZGON_ID)
REFERENCES EWIDENCJA_DPS_ZGON (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SWIADCZENIE_ZWROT ADD CONSTRAINT ZADLUZENIE_POZYCJA_SWIADCZENIE_ZWROT_fk
FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
REFERENCES ZADLUZENIE_POZYCJA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;


-- przypominacz nierozliczonych zgonów mieszkańców
INSERT INTO QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION,
		JOB_CLASS_NAME, IS_DURABLE, IS_UPDATE_DATA, IS_NONCONCURRENT, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
	VALUES('QuartzServer', 'RozliczenieZgonMieszkanca', 'PRZYPOMINACZE', 'Aktualizuje dane nt. nierozliczonych zgonów mieszkańców',
		'pl.topteam.dps.timeTask.przypominacze.RozliczenieZgonMieszkanca', 'FALSE', 'FALSE', 'FALSE', 'FALSE', '', false);

INSERT INTO QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP,
		DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, MISFIRE_INSTR)
	VALUES('QuartzServer', 'WyzwalaczRozliczenieZgonMieszkanca', 'PRZYPOMINACZE', 'RozliczenieZgonMieszkanca', 'PRZYPOMINACZE',
		'Aktualizuje dane nt. nierozliczonych zgonów mieszkańców', 1276514580000, 1276514570000, 5, 'ACQUIRED', 'CRON', 1276512961000, 0, 1);

INSERT INTO QRTZ_CRON_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)
	VALUES('QuartzServer', 'WyzwalaczRozliczenieZgonMieszkanca', 'PRZYPOMINACZE', '0 0 6 * * ?', 'Europe/Belgrade');

	
-- nowe triggery
CREATE TRIGGER ADEL_WPLATA AFTER
  DELETE ON WPLATA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.wplata.AfterWplataDelete";
CREATE TRIGGER AINS_WPLATA AFTER
  INSERT ON WPLATA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.wplata.AfterWplataInsert";


--//@UNDO
-- SQL to undo the change goes here.

