package pl.topteam.db.h2.backup.offline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.h2.tools.Script;

class BackupRunner {
	/**
	 * Lista opcji, które są podawane do gbaka
	 */
	private List<Command> listaOpcji;
	
	public BackupRunner() {
		listaOpcji = new ArrayList<>();
	}
	
	public void addCommandLineOption(Command command) {
		//sprawdzanie poprawnosci wprowadzanej komendy
		if(command == null) {
			throw new IllegalArgumentException("Parametr command jest wymagany");
		}
		if(! command.isValid()) {
			throw new IllegalArgumentException("Nie wyspecyfikowano wszystkich parametrów dla opcji: " + command.getParametrPrefix());
		}

		listaOpcji.add(command);
	}

	public void resetPreviousExecute() {
		listaOpcji.clear();
	}

	public void run() throws Exception {
		Script.main(
				this.toStringCommand());
	}
	
	public List<Command> getListaOpcji() {
		return listaOpcji;
	}

	public void setListaOpcji(List<Command> listaOpcji) {
		this.listaOpcji = listaOpcji;
	}

	public String[] toStringCommand() {
		List<String> rtnList = new ArrayList<>();
		
		for(int i = 0; i < listaOpcji.size(); ++i) {
			rtnList.addAll(
					Arrays.asList(
							listaOpcji.get(i).toStringCommand()));
		}
		
		return rtnList.toArray(new String[] {});
	}
}
