package pl.topteam.db.h2.backup.offline;

import java.io.File;

public final class BakcupDatabase {

	public static void backupDatabase(
			String databaseUrl,
			String user,
			String password,
			File toFile,
			Boolean czyKompresja) throws Exception {
		BackupRunner backupRunner = new BackupRunner();
		
		// url bazy danych
		backupRunner.addCommandLineOption(
				new Command(
						CommandParameterEnum.DATABASE_URL,
						new CommandOption(databaseUrl)));

		// user
		backupRunner.addCommandLineOption(
				new Command(
						CommandParameterEnum.H2_USER_NAME,
						new CommandOption(user)));

		// password
		backupRunner.addCommandLineOption(
				new Command(
						CommandParameterEnum.H2_PASSWORD,
						new CommandOption(password)));

		// backup file
		backupRunner.addCommandLineOption(
				new Command(
						CommandParameterEnum.SCRIPT_FILE_NAME,
						new CommandOption(toFile.getAbsolutePath())));

		//komenda kompresji
		if(czyKompresja != null && czyKompresja) {
			backupRunner.addCommandLineOption(
				new Command(
						CommandParameterEnum.OPTIONS,
						new CommandOption("compression", "zip")));
		}

		backupRunner.run();
	}
}
