package pl.topteam.db.h2.backup.offline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class Command {
	private CommandParameterEnum parametrPrefix;
	private CommandOption parametr;

	public Command() {
		this(null, null);
	}

	public Command(CommandParameterEnum parametrPrefix) {
		this(parametrPrefix, null);
	}

	public Command(CommandParameterEnum parametrPrefix, CommandOption parametr) {
		this.parametrPrefix = parametrPrefix;
		this.parametr = parametr;
	}

	/**
	 * Czy ta komenda jest poprawna składniowo. (nie brakuje wymaganych parametrów)
	 * @return
	 */
	boolean isValid() {
		if(this.parametrPrefix == null) {
			return false;
		}

		if(StringUtils.isEmpty(
				this.parametr.toString()) &&
				this.parametrPrefix.isExtraParameterNeeded()) {
			return false;
		}

		return true;
	}

	public CommandParameterEnum getParametrPrefix() {
		return parametrPrefix;
	}

	public void setParametrPrefix(CommandParameterEnum parametrPrefix) {
		this.parametrPrefix = parametrPrefix;
	}

	public CommandOption getParametr() {
		return parametr;
	}

	public void setParametr(CommandOption parametr) {
		this.parametr = parametr;
	}

	public String[] toStringCommand() {
		List<String> rtnList = new ArrayList<>();

		rtnList.add(
				this.getParametrPrefix().toString());

		if(this.getParametr() != null) {
			rtnList.addAll(
					Arrays.asList(
							this.getParametr().toStringCommand()));
		}

		return rtnList.toArray(new String[] {});
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Command) {
			Command objCommand = (Command) obj;
			CommandParameterEnum objParameterEnum = objCommand.getParametrPrefix();

			if(this.parametrPrefix == null &&
					objParameterEnum == null) {
				return true;
			} else if (this.parametrPrefix != null &&
					objParameterEnum != null) {
				return this.parametrPrefix.equals(objParameterEnum);
			}
		}

		return false;
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder().append(
				this.parametrPrefix).toHashCode();
	}
}
