package pl.topteam.db.h2.backup.offline;

import java.util.ArrayList;

import org.apache.commons.lang3.StringUtils;

public class CommandOption extends ArrayList<String> {
	private static final long serialVersionUID = -8018507508704113821L;

	private static void checkOption(String option) {
		if(StringUtils.isEmpty(option)) {
			throw new IllegalArgumentException("'option' nie może być pustym ciągiem znaków");
		}
	}

	public CommandOption(String option) {
		super();

		addOption(option);
	}

	public CommandOption(String... option) {
		super();

		addOption(option);
	}

	public void addOption(String option) {
		// sprawdzanie parametru
		checkOption(option);

		add(option);
	}

	public void addOption(String... option) {
		// sprawdzanie wszystkich opcji przed dodaniem
		for(String tmpOption : option) {
			checkOption(tmpOption);
		}

		// dodawanie opcji jeśli wszystko jest OK
		for(String tmpOption : option) {
			add(tmpOption);
		}
	}

	public String[] toStringCommand() {
		return this.toArray(new String[] {});
	}
}
