package pl.topteam.db.h2.backup.offline;

enum CommandParameterEnum {
	DATABASE_URL("-url", true), // The database URL (jdbc:...)
	H2_USER_NAME("-user", true), // The user name (default: sa)
	H2_PASSWORD("-password", true), // The password
	SCRIPT_FILE_NAME("-script", true), // The target script file name (default: backup.sql)
	OPTIONS("-options", true), // A list of options (only for embedded H2, see RUNSCRIPT)
	QUIET_BACKUP("-quiet", true)
	;

	/**
	 * Opcja wstawiana dla GBAKa w linii komend
	 */
	private String prefix;
	
	/**
	 * Czy jest potrzebny dodatkowy opis dla parametru
	 */
	private boolean isExtraParameterNeeded;
	
	private CommandParameterEnum(String prefix, boolean isExtraParameterNeeded) {
		this.prefix = prefix;
		this.isExtraParameterNeeded = isExtraParameterNeeded;
	}

	public boolean isExtraParameterNeeded() {
		return this.isExtraParameterNeeded;
	}

	@Override
	public String toString() {
		return this.prefix;
	}
}
