--// migracja z dnia 20100916.
-- Migration SQL that makes the change goes here.

CREATE TABLE DECYZJA_UCHYLAJACA (
    ID IDENTITY NOT NULL,
    EWIDENCJA_ID BIGINT(10) NOT NULL,
    SZABLON_WYDRUKU_ID BIGINT(7),
    NR VARCHAR(50) NOT NULL,
    DATA_WYDANIA DATE NOT NULL,
    DATA_UCHYLENIA DATE NOT NULL,
    CONSTRAINT DECYZJA_UCHYLAJACA_pk PRIMARY KEY (ID)
);

ALTER TABLE DECYZJA_UCHYLAJACA ADD CONSTRAINT SZABLON_WYDRUKU_DECYZJA_UCHYLAJACA_fk
FOREIGN KEY (SZABLON_WYDRUKU_ID)
REFERENCES SZABLON_WYDRUKU (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DECYZJA_UCHYLAJACA ADD CONSTRAINT EWIDENCJA_DPS_DECYZJA_UCHYLAJACA_fk
FOREIGN KEY (EWIDENCJA_ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE TABLE OSOBA_SPRAWOZDANIE (
    ID IDENTITY NOT NULL,
    OSOBA_ID BIGINT(10) NOT NULL,
    TYP VARCHAR(50),
    WARTOSC_S VARCHAR(50),
    CONSTRAINT OSOBA_SPRAWOZDANIE_pk PRIMARY KEY (ID)
);

ALTER TABLE OSOBA_SPRAWOZDANIE ADD CONSTRAINT OSOBA_OSOBA_SPRAWOZDANIE_fk
FOREIGN KEY (OSOBA_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE TABLE OSOBA_SPRAWOZDANIE_WARTOSC (
    ID IDENTITY NOT NULL,
    OSOBA_SPRAWOZDANIE_ID BIGINT(7) NOT NULL,
    CONSTRAINT OSOBA_SPRAWOZDANIE_WARTOSC_pk PRIMARY KEY (ID)
);

ALTER TABLE OSOBA_SPRAWOZDANIE_WARTOSC ADD CONSTRAINT OSOBA_SPRAWOZDANIE_OSOBA_SPRAWOZDANIE_WARTOSC_fk
FOREIGN KEY (OSOBA_SPRAWOZDANIE_ID)
REFERENCES OSOBA_SPRAWOZDANIE (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

DROP TABLE IF EXISTS SPRAWOZDANIE_PODPOWIEDZ;

CREATE TABLE SPRAWOZDANIE_PODPOWIEDZ (
    ID IDENTITY NOT NULL,
    TYP VARCHAR(50) NOT NULL,
    CONSTRAINT SPRAWOZDANIE_PODPOWIEDZ_pk PRIMARY KEY (ID)
);

CREATE TABLE SPRAWOZDANIE_PODPOWIEDZ_WARTOSC (
    ID IDENTITY NOT NULL,
    SPRAWOZDANIE_PODPOWIEDZ_ID BIGINT(7) NOT NULL,
    WARTOSC_S VARCHAR(50) NOT NULL,
    CONSTRAINT SPRAWOZDANIE_PODPOWIEDZ_WARTOSC_pk PRIMARY KEY (ID)
);

ALTER TABLE SPRAWOZDANIE_PODPOWIEDZ_WARTOSC ADD CONSTRAINT SPRAWOZDANIE_PODPOWIEDZ_SPRAWOZDANIE_PODPOWIEDZ_WARTOSC_fk
FOREIGN KEY (SPRAWOZDANIE_PODPOWIEDZ_ID)
REFERENCES SPRAWOZDANIE_PODPOWIEDZ (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE UNIQUE INDEX PR_UNIKALNA_SPR_PODPOWIEDZ
    ON SPRAWOZDANIE_PODPOWIEDZ (typ);
    
CREATE UNIQUE INDEX PR_UNIKALNA_OSO_SPR_PODPOWIEDZ
    ON OSOBA_SPRAWOZDANIE (typ);


--//@UNDO
-- SQL to undo the change goes here.

