--// migracja poprawiajaca wydajnosc widokow.
-- Migration SQL that makes the change goes here.

-- najnowszy dowód osobisty (po dacie wydania) wprowadzony dla osoby
CREATE OR REPLACE VIEW AKTUALNE_DOWODY_OSOB AS
  SELECT dOs.*
  FROM DOWOD_OSOBISTY dOs
       LEFT OUTER JOIN DOWOD_OSOBISTY tmpDow ON dOs.OSOBA_ID = tmpDow.OSOBA_ID
         AND dOs.DATA_WYDANIA < tmpDow.DATA_WYDANIA
  WHERE
    tmpDow.ID IS NULL;

-- najnowsze decyzje o aliementacji i odpłatności
CREATE OR REPLACE VIEW AKTUALNE_DECYZJE_ALIMENTACYJNE_ODPLATNOSCI AS
  SELECT odpl.*
  FROM DECYZJA_O_ODPLATNOSCI odpl
    LEFT OUTER JOIN DECYZJA_O_ODPLATNOSCI tmpDec ON odpl.MIESZKANIEC_ID = tmpDec.MIESZKANIEC_ID
      AND odpl.CZLONEK_RODZ_ID = tmpDec.CZLONEK_RODZ_ID
      AND coalesce(odpl.OBOWIAZUJE_OD, odpl.DATA_WYDANIA) < coalesce(tmpDec.OBOWIAZUJE_OD, tmpDec.DATA_WYDANIA)
  WHERE
    tmpDec.ID IS NULL;
    
-- aktualne adresy osób
CREATE OR REPLACE VIEW AKTUALNE_ADRESY_OSOB AS
  SELECT adr.*, osAdr.OSOBA_ID
  FROM ADRES adr
    JOIN OSOBA_ADRES osAdr ON adr.ID = osAdr.ADRES_ID
    LEFT OUTER JOIN ADRES tmpAdr ON tmpAdr.ID = osAdr.ADRES_ID
      AND adr.ID < tmpAdr.ID
      AND adr.TYP = tmpAdr.TYP
  WHERE
    tmpAdr.ID IS NULL;

--//@UNDO
-- SQL to undo the change goes here.

