--// migracja wprowadzajaca ewidencje pokoi.
-- Migration SQL that makes the change goes here.

DROP TABLE IF EXISTS RAPORT_UPRAWNIENIE;

DROP TABLE IF EXISTS EWIDENCJA_POKOJE;

CREATE TABLE DPS_JEDNOSTKA_POKOJ (
    ID IDENTITY NOT NULL,
    DPS_JEDNOSTKA_ID BIGINT(7) NOT NULL,
    LICZBA_MIEJSC INTEGER NOT NULL,
    NR VARCHAR(5),
    PIETRO INTEGER,
    CONSTRAINT DPS_JEDNOSTKA_POKOJ_pk PRIMARY KEY (ID)
);

ALTER TABLE DPS_JEDNOSTKA_POKOJ ADD CONSTRAINT DPS_JEDNOSTKA_EWIDENCJA_POKOJE_fk
FOREIGN KEY (DPS_JEDNOSTKA_ID)
REFERENCES DPS_JEDNOSTKA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

CREATE TABLE EWIDENCJA_POKOJE (
    ID IDENTITY NOT NULL,
    DPS_POKOJ_ID BIGINT(10) NOT NULL,
    EWIDENCJA_DPS_ID BIGINT(10) NOT NULL,
    POPRZEDNI_POKOJ_ID BIGINT(7),
    DATA_OD DATE NOT NULL,
    CONSTRAINT EWIDENCJA_POKOJE_pk PRIMARY KEY (ID)
);

ALTER TABLE EWIDENCJA_POKOJE ADD CONSTRAINT DPS_JEDNOSTKA_POKOJ_EWIDENCJA_POKOJE_fk
FOREIGN KEY (DPS_POKOJ_ID)
REFERENCES DPS_JEDNOSTKA_POKOJ (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE EWIDENCJA_POKOJE ADD CONSTRAINT EWIDENCJA_DPS_EWIDENCJA_POKOJE_fk
FOREIGN KEY (EWIDENCJA_DPS_ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE EWIDENCJA_POKOJE ADD CONSTRAINT EWIDENCJA_POKOJE_EWIDENCJA_POKOJE_fk
FOREIGN KEY (POPRZEDNI_POKOJ_ID)
REFERENCES EWIDENCJA_POKOJE (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

CREATE VIEW AKTUALNE_POKOJE_MIESZKANCOW AS
	SELECT ewDps.OSOBA_ID as MIESZKANIEC_ID, ewPok.*
	FROM EWIDENCJA_DPS ewDps
		JOIN EWIDENCJA_POKOJE ewPok ON ewDps.ID = ewPok.EWIDENCJA_DPS_ID
			AND ewDps.TYP = 'MIESZKANIEC' AND ewDps.DATA_DO IS NULL
		LEFT OUTER JOIN EWIDENCJA_POKOJE nEwPok ON ewPok.ID = nEwPok.POPRZEDNI_POKOJ_ID
	WHERE
		nEwPok.ID IS NULL;

CREATE UNIQUE INDEX EW_UNIKALNY_ID_POKOJU
	ON DPS_JEDNOSTKA_POKOJ (PIETRO, NR);
	
CREATE INDEX EW_NR_POKOJU
	ON DPS_JEDNOSTKA_POKOJ (NR);

--//@UNDO
-- SQL to undo the change goes here.

