--// migracja projekt magazynu lekow.
-- Migration SQL that makes the change goes here.


CREATE TABLE UMOWA_APTEKA (
                ID IDENTITY NOT NULL,
                DATA_OD DATE NOT NULL,
                DATA_DO DATE NOT NULL,
                KWOTA DECIMAL(10,2) NOT NULL,
                NR VARCHAR(50) NOT NULL,
                CONSTRAINT UMOWA_APTEKA_pk PRIMARY KEY (ID)
);

CREATE TABLE RECEPTA (
                ID IDENTITY NOT NULL,
                EWIDENCJA_DPS_ID BIGINT(10) NOT NULL,
                DATA_WYSTAWIENIA DATE NOT NULL,
                CONSTRAINT RECEPTA_pk PRIMARY KEY (ID)
);

CREATE TABLE REALIZACJA_RECEPTA (
                ID IDENTITY NOT NULL,
                RECEPTA_ID BIGINT(10) NOT NULL,
                UMOWA_ID BIGINT(10),
                DATA DATE NOT NULL,
                DATA_REALIZACJI DATE,
                KWOTA DECIMAL(10,2) NOT NULL,
                NR VARCHAR(50),
                CONSTRAINT REALIZACJA_RECEPTA_pk PRIMARY KEY (ID)
);

CREATE TABLE PORA_DNIA (
                ID IDENTITY NOT NULL,
                CZY_AKTUALNA BOOLEAN,
                NAZWA VARCHAR(50) NOT NULL,
                SKROT VARCHAR(10) NOT NULL,
                KOLEJNOSC INTEGER,
                CONSTRAINT PORA_DNIA_pk PRIMARY KEY (ID)
);

CREATE TABLE DAWKOWANIE (
                ID IDENTITY NOT NULL,
                POPRZEDNIE_DAWKOWANIE_ID BIGINT(7),
                EWIDENCJA_DPS_ID BIGINT(7) NOT NULL,
                DATA_OD DATE NOT NULL,
                CONSTRAINT DAWKOWANIE_pk PRIMARY KEY (ID)
);

CREATE TABLE LEK (
                KOD_BAZYL BIGINT(7) NOT NULL,
                DAWKA VARCHAR(42),
                NAZWA VARCHAR(120) NOT NULL,
                OPAKOWANIE_ILOSC DECIMAL(10,2) NOT NULL,
                OPAKOWANIE_JEDNOSTKA_POJEMNOSCI VARCHAR(50) NOT NULL,
                OPAKOWANIE_OPIS_BAZYL VARCHAR(42) NOT NULL,
                POSTAC VARCHAR(32) NOT NULL,
                CONSTRAINT LEK_pk PRIMARY KEY (KOD_BAZYL)
);

CREATE TABLE RECEPTA_LEK (
                RECEPTA_ID BIGINT(10) NOT NULL,
                KOD_BAZYL BIGINT(7) NOT NULL,
                CONSTRAINT RECEPTA_LEK_pk PRIMARY KEY (RECEPTA_ID, KOD_BAZYL)
);

CREATE TABLE DAWKA_LEK (
                DAWKOWANIE_ID BIGINT(7) NOT NULL,
                PORA_ID BIGINT(10) NOT NULL,
                KOD_BAZYL BIGINT(7) NOT NULL,
                CZY_RECEPTA BOOLEAN,
                DAWKA DECIMAL(10,2),
                CONSTRAINT DAWKA_LEK_pk PRIMARY KEY (DAWKOWANIE_ID, PORA_ID, KOD_BAZYL)
);

ALTER TABLE REALIZACJA_RECEPTA ADD CONSTRAINT UMOWA_APTEKA_FAKTURA_RECEPTA_fk
FOREIGN KEY (UMOWA_ID)
REFERENCES UMOWA_APTEKA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DAWKOWANIE ADD CONSTRAINT OSOBA_DAWKOWANIE_fk
FOREIGN KEY (EWIDENCJA_DPS_ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE RECEPTA ADD CONSTRAINT OSOBA_RECEPTA_fk
FOREIGN KEY (EWIDENCJA_DPS_ID)
REFERENCES EWIDENCJA_DPS (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE RECEPTA_LEK ADD CONSTRAINT RECEPTA_RECEPTA_LEK_fk
FOREIGN KEY (RECEPTA_ID)
REFERENCES RECEPTA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE REALIZACJA_RECEPTA ADD CONSTRAINT RECEPTA_FAKTURA_RECEPTA_fk
FOREIGN KEY (RECEPTA_ID)
REFERENCES RECEPTA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DAWKA_LEK ADD CONSTRAINT PORA_DNIA_DAWKA_LEK_fk
FOREIGN KEY (PORA_ID)
REFERENCES PORA_DNIA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DAWKOWANIE ADD CONSTRAINT DAWKOWANIE_DAWKOWANIE_fk
FOREIGN KEY (POPRZEDNIE_DAWKOWANIE_ID)
REFERENCES DAWKOWANIE (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DAWKA_LEK ADD CONSTRAINT DAWKOWANIE_DAWKA_LEK_fk
FOREIGN KEY (DAWKOWANIE_ID)
REFERENCES DAWKOWANIE (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DAWKA_LEK ADD CONSTRAINT LEK_DAWKA_LEK_fk
FOREIGN KEY (KOD_BAZYL)
REFERENCES LEK (KOD_BAZYL)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE RECEPTA_LEK ADD CONSTRAINT LEK_RECEPTA_LEK_fk
FOREIGN KEY (KOD_BAZYL)
REFERENCES LEK (KOD_BAZYL)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE UNIQUE INDEX MG_LEK_UNIKALNY_KOD_BAZYL
    ON LEK (KOD_BAZYL);
    
INSERT INTO PORA_DNIA(NAZWA, SKROT, CZY_AKTUALNA, KOLEJNOSC) VALUES ('rano', 'R', true, 1);
INSERT INTO PORA_DNIA(NAZWA, SKROT, CZY_AKTUALNA, KOLEJNOSC) VALUES ('południe', 'P', true, 2);
INSERT INTO PORA_DNIA (NAZWA, SKROT, CZY_AKTUALNA, KOLEJNOSC) VALUES ('wieczór', 'W', true, 3);
INSERT INTO PORA_DNIA(NAZWA, SKROT, CZY_AKTUALNA, KOLEJNOSC) VALUES ('noc', 'N', true, 4);

CREATE VIEW AKTUALNE_DAWKI_LEKOW AS
	SELECT ewDps.OSOBA_ID, d.*
		FROM AKTUALNE_WPISY_EWIDENCJI_OSOB ewDps
			JOIN DAWKOWANIE d ON d.EWIDENCJA_DPS_ID = ewDps.ID
			LEFT OUTER JOIN DAWKOWANIE najD ON najD.EWIDENCJA_DPS_ID = ewDps.ID
				AND najD.POPRZEDNIE_DAWKOWANIE_ID = d.ID
	WHERE
		najD.ID IS NULL;


--//@UNDO
-- SQL to undo the change goes here.

