--// migracja wersjonowanie produktu.
-- Migration SQL that makes the change goes here.

-- zmiany w słownikach (skomplikowałem zapytanie z wuwagi na to, że w niektórych bazach to słowo już zostało wprowadzone)
INSERT INTO SLOWO (SLOWNIK_ID, KOD, WART_STRING)
	SELECT
		sl.ID as SLOWNIK_ID,
		'673' as KOD,
		STRINGDECODE('Zasi\u0142ek piel\u0119gnacyjny') as WART_STRING
	FROM SLOWNIK sl
	WHERE
		sl.NAZWA = 'KOD_RODZAJU_SWIADCZENIA'
		AND NOT EXISTS (
			SELECT sw.*
			FROM SLOWO sw
			WHERE
				sw.SLOWNIK_ID = sl.ID
				AND sw.KOD = '673'
		);

-- zmiana wersji oprogramowania u użytkowników
DELETE FROM PRACOWNIK_PARAMETR p WHERE p.TYP = 'INFO_WERSJA_APLIKACJI';

CREATE TABLE WERSJA (
    WERSJA VARCHAR(50) NOT NULL,
    DATA DATE NOT NULL,
    CONSTRAINT WERSJA_pk PRIMARY KEY (WERSJA)
);

-- domyślnie wszystkie wersje zgodnie z datami ich utworzenia
INSERT INTO WERSJA(WERSJA, DATA) VALUES('G_1_00_2_0_00', '2011-01-24');
INSERT INTO WERSJA(WERSJA, DATA) VALUES('G_1_00_2_1_00', '2011-02-11');
INSERT INTO WERSJA(WERSJA, DATA) VALUES('G_1_00_2_2_00', '2011-03-01');
INSERT INTO WERSJA(WERSJA, DATA) VALUES('G_1_00_2_3_00', '2011-04-05');
INSERT INTO WERSJA(WERSJA, DATA) VALUES('G_1_00_2_5_00', '2011-05-31');
INSERT INTO WERSJA(WERSJA, DATA) VALUES('G_1_00_2_7_00', '2011-09-14');
INSERT INTO WERSJA(WERSJA, DATA) VALUES('G_1_00_2_8_00', '2011-10-24');

-- dla każdeg pracownika przyporzadkowuję ostatni wyświetlony komunikat o zmianach
INSERT INTO PRACOWNIK_PARAMETR(PRACOWNIK_ID, TYP, WARTOSC_S)
	SELECT
		p.ID as PRACOWNIK_ID,
		'INFO_WERSJA_APLIKACJI_ZMIANY' as TYP,
		'G_1_00_2_8_00' as WARTOSC_S
	FROM PRACOWNIK p;

--//@UNDO
-- SQL to undo the change goes here.

