--// migracja poprawki meldunki czasowe.
-- Migration SQL that makes the change goes here.

UPDATE QRTZ_JOB_DETAILS jb
  SET jb.JOB_CLASS_NAME = 'pl.topteam.dps.timeTask.przypominacze.MeldunekCzasowyMieszkaniec'
WHERE
  jb.JOB_NAME = 'MeldunekCzasowyMieszkaniec';
  
ALTER TABLE EWIDENCJA_DPS ADD STALE_ZAMELDOWANIE_DOM BOOLEAN;

-- aktualizacja danych nt obecnych mieszkańców (domyślnie wpisy bez meldunkow sa na stale)
UPDATE EWIDENCJA_DPS ew
	SET ew.STALE_ZAMELDOWANIE_DOM = TRUE
WHERE 
	ew.TYP = 'MIESZKANIEC'
	AND NOT EXISTS (
		SELECT m.ID
		FROM MELDUNEK m
		WHERE
			m.EWIDENCJA_ID = ew.ID
	);
	
-- aktualizacja widoków
DROP VIEW IF EXISTS AKTUALNE_DAWKI_LEKOW;
DROP VIEW IF EXISTS PRACOWNIK_MIESZKANIEC_CZYNNOSCI;
DROP VIEW IF EXISTS AKTUALNE_WPISY_EWIDENCJI_OSOB;

CREATE VIEW AKTUALNE_WPISY_EWIDENCJI_OSOB AS
	SELECT ew.*
	FROM EWIDENCJA_DPS ew
	WHERE ew.DATA_DO IS NULL;
CREATE VIEW PRACOWNIK_MIESZKANIEC_CZYNNOSCI AS
	SELECT pr.ID as PRACOWNIK_ID, wpisEwid.OSOBA_ID AS MIESZKANIEC_ID, grUpr.CZYNNOSC_ID, grUpr.TYP_UPRAWNIENIA, plan.DATA_OD, plan.DATA_DO
	FROM AKTUALNE_WPISY_EWIDENCJI_OSOB wpisEwid
		JOIN PLAN_WSPARCIA_MIESZKANCA plan ON wpisEwid.ID = plan.EWIDENCJA_ID
			AND wpisEwid.TYP = 'MIESZKANIEC'
		JOIN PLAN_WSPARCIA_CZYNNOSC planCz ON plan.ID = planCz.PLAN_ID
		JOIN GRUPA_UPRAWNIENIE_KAT_USLUG grUpr ON planCz.CZYNNOSC_ID = grUpr.CZYNNOSC_ID
		JOIN PRACOWNIK pr ON grUpr.GRUPA_ID = pr.GRUPA_ID;
CREATE VIEW AKTUALNE_DAWKI_LEKOW AS
	SELECT ewDps.OSOBA_ID, d.*
		FROM AKTUALNE_WPISY_EWIDENCJI_OSOB ewDps
			JOIN DAWKOWANIE d ON d.EWIDENCJA_DPS_ID = ewDps.ID
				AND d.DATA_OD <= CURRENT_DATE()
			LEFT OUTER JOIN DAWKOWANIE najD ON najD.EWIDENCJA_DPS_ID = ewDps.ID
				AND najD.POPRZEDNIE_DAWKOWANIE_ID = d.ID
	WHERE
		najD.ID IS NULL;

-- zmiana wersji aplikacji
DELETE FROM PRACOWNIK_PARAMETR p WHERE p.TYP = 'INFO_WERSJA_APLIKACJI';


--//@UNDO
-- SQL to undo the change goes here.

