--// migracja recepty lekarze.
-- Migration SQL that makes the change goes here.

-- wstawianie nieistniejących wpisów lekarzy
INSERT INTO SLOWO(SLOWNIK_ID, WART_STRING, KOD)
	SELECT 
		(SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_LEKARZA') AS SLOWNIK_ID,
		tmp.WART_STRING,
		LPAD(
			CAST(
				(ROWNUM() +
						SELECT CAST(COALESCE(MAX(s.KOD), '-1') as INTEGER) as MAX_KOD
						FROM SLOWNIK sl
							JOIN SLOWO s ON sl.ID = s.SLOWNIK_ID
								AND sl.ID = (
									SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_LEKARZA'))
					as VARCHAR), 3, '0') as KOD
	FROM (
		SELECT
			DISTINCT CONCAT(p.NAZWISKO, ' ', p.IMIE) as WART_STRING
		FROM PRACOWNIK p
			JOIN RECEPTA r ON r.PRACOWNIK_WYSTAWIL_ID = p.ID
		WHERE NOT EXISTS (
			SELECT s.WART_STRING
			FROM SLOWO s
			WHERE
				s.SLOWNIK_ID = (SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_LEKARZA')
				AND UPPER(s.WART_STRING) = UPPER(CONCAT(p.NAZWISKO, ' ', p.IMIE))
		)
	) as tmp;

-- aktualizacja tabeli RECEPTA
ALTER TABLE RECEPTA ADD LEKARZ_WYSTAWIL_ID BIGINT(10);
ALTER TABLE RECEPTA ADD CONSTRAINT SLOWO_LEKARZ_RECEPTA_fk
	FOREIGN KEY (LEKARZ_WYSTAWIL_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- przepisywanie lekarzy na słowniki
UPDATE RECEPTA r
	SET r.LEKARZ_WYSTAWIL_ID = (
		SELECT s.ID
		FROM SLOWNIK sl
			JOIN SLOWO s ON sl.ID = s.SLOWNIK_ID
				AND sl.ID = (SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_LEKARZA')
				AND s.WART_STRING = (
					SELECT CONCAT(p.NAZWISKO, ' ', p.IMIE)
					FROM PRACOWNIK p
					WHERE
						p.ID = r.PRACOWNIK_WYSTAWIL_ID
				)
	)
WHERE r.PRACOWNIK_WYSTAWIL_ID IS NOT NULL;
	
-- usuwanie niepotrzebnych kolumn
ALTER TABLE RECEPTA DROP CONSTRAINT IF EXISTS PRACOWNIK_RECEPTA_fk;
ALTER TABLE RECEPTA DROP COLUMN PRACOWNIK_WYSTAWIL_ID;



--//@UNDO
-- SQL to undo the change goes here.

