--// migracja fundacja cd.
-- Migration SQL that makes the change goes here.

-- aktualizacja tabel
ALTER TABLE ODPLATNOSC_SKLADNIK ADD KWOTA_DZIEN DECIMAL(10,2);
ALTER TABLE UMOWA ADD DATA_DO DATE;

-- poprawki widoku
DROP VIEW AKTUALNE_WPISY_EWIDENCJI_OSOB;
CREATE VIEW AKTUALNE_WPISY_EWIDENCJI_OSOB AS
	SELECT ew.*
	FROM EWIDENCJA_DPS ew
		LEFT OUTER JOIN EWIDENCJA_DPS nEw ON nEw.EWID_POPRZEDNI_WPIS_ID = ew.ID
	WHERE nEw.ID IS NULL;
CREATE VIEW AKTUALNE_DAWKI_LEKOW AS
	SELECT ewDps.OSOBA_ID, d.*
		FROM AKTUALNE_WPISY_EWIDENCJI_OSOB ewDps
			JOIN DAWKOWANIE d ON d.EWIDENCJA_DPS_ID = ewDps.ID
				AND d.DATA_OD <= CURRENT_DATE()
			LEFT OUTER JOIN DAWKOWANIE najD ON najD.EWIDENCJA_DPS_ID = ewDps.ID
				AND najD.POPRZEDNIE_DAWKOWANIE_ID = d.ID
	WHERE
		najD.ID IS NULL;
CREATE VIEW PRACOWNIK_MIESZKANIEC_CZYNNOSCI AS
	SELECT pr.ID as PRACOWNIK_ID, wpisEwid.OSOBA_ID AS MIESZKANIEC_ID, grUpr.CZYNNOSC_ID, grUpr.TYP_UPRAWNIENIA, plan.DATA_OD, plan.DATA_DO
	FROM AKTUALNE_WPISY_EWIDENCJI_OSOB wpisEwid
		JOIN PLAN_WSPARCIA_MIESZKANCA plan ON wpisEwid.ID = plan.EWIDENCJA_ID
			AND wpisEwid.TYP = 'MIESZKANIEC'
		JOIN PLAN_WSPARCIA_CZYNNOSC planCz ON plan.ID = planCz.PLAN_ID
		JOIN GRUPA_UPRAWNIENIE_KAT_USLUG grUpr ON planCz.CZYNNOSC_ID = grUpr.CZYNNOSC_ID
		JOIN PRACOWNIK pr ON grUpr.GRUPA_ID = pr.GRUPA_ID;


-- przypomnianie o końcu terminu ważności umów z mieszkańcami
INSERT INTO QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION,
		JOB_CLASS_NAME, IS_DURABLE, IS_UPDATE_DATA, IS_NONCONCURRENT, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
	VALUES('QuartzServer', 'UmowaWaznosc', 'PRZYPOMINACZE', 'Aktualizuje dane nt. zbliżających się terminów ważności umów wg ustalonych przez użytkownika parametrów',
		'pl.topteam.dps.timeTask.przypominacze.UmowaWaznosc', 'FALSE', 'FALSE', 'FALSE', 'FALSE', '', false);

INSERT INTO QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP,
		DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, MISFIRE_INSTR)
	VALUES('QuartzServer', 'WyzwalaczUmowaWaznosc', 'PRZYPOMINACZE', 'UmowaWaznosc', 'PRZYPOMINACZE',
		'Aktualizuje dane nt. zbliżających się terminów ważności umów wg ustalonych przez użytkownika parametrów', 1276514580000, 1276514570000, 5, 'ACQUIRED', 'CRON', 1276512961000, 0, 1);

INSERT INTO QRTZ_CRON_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)
	VALUES('QuartzServer', 'WyzwalaczUmowaWaznosc', 'PRZYPOMINACZE', '0 0 6 * * ?', 'Europe/Belgrade');

-- przypomnianie o końcu terminu ważności umów z mieszkańcami (dla wszystkich mieszkańców)
INSERT INTO QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION,
    JOB_CLASS_NAME, IS_DURABLE, IS_UPDATE_DATA, IS_NONCONCURRENT, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
  VALUES('QuartzServer', 'UmowaWaznoscMieszkaniec', 'PRZYPOMINACZE', 'Aktualizuje dane nt. zbliżającego się terminu umów dla mieszkańca',
    'pl.topteam.dps.timeTask.przypominacze.UmowaWaznoscMieszkaniec', 'TRUE', 'FALSE', 'FALSE', 'FALSE', '', true);


-- zmiana wersji
DELETE FROM PRACOWNIK_PARAMETR p WHERE p.TYP = 'INFO_WERSJA_APLIKACJI';

--//@UNDO
-- SQL to undo the change goes here.

