--// migracja polityka bezpiczenstwa.
-- Migration SQL that makes the change goes here.

CREATE TABLE POLITYKA_BEZPIECZENSTWA (
    ID IDENTITY NOT NULL,
    DL_HISTORII_HASLA INTEGER NOT NULL,
    MIN_DL_HASLA INTEGER NOT NULL,
    MAX_DL_HASLA INTEGER,
    PROB_N_LOGOWAN INTEGER NOT NULL,
    PROB_CZAS_BLOKADY INTEGER NOT NULL,
    L_DNI_OBOWIAZYWANIA_HASLA INTEGER NOT NULL,
    L_DNI_ZMIANA_HASLA INTEGER NOT NULL,
    ZASTOSUJ BOOLEAN,
    CONSTRAINT POLITYKA_BEZPIECZENSTWA_pk PRIMARY KEY (ID)
);

CREATE TABLE GRUPA_ZNAKOW (
    POLITYKA_ID BIGINT(10) NOT NULL,
    GRUPA_ZNAKOW VARCHAR(50) NOT NULL,
    ZNAKI VARCHAR(50),
    MIN_ZNAKOW INTEGER NOT NULL,
    CONSTRAINT GRUPA_ZNAKOW_pk PRIMARY KEY (POLITYKA_ID, GRUPA_ZNAKOW)
);

CREATE TABLE PRACOWNIK_HISTORIA_HASLA (
    PRACOWNIK_ID BIGINT(10) NOT NULL,
    NR_PORZADKOWY INTEGER NOT NULL,
    HASLO VARCHAR(90) NOT NULL,
    CONSTRAINT PRACOWNIK_HISTORIA_HASLA_pk PRIMARY KEY (PRACOWNIK_ID, NR_PORZADKOWY)
);

ALTER TABLE GRUPA_ZNAKOW ADD CONSTRAINT POLITYKA_BEZPIECZENSTWA_GRUPA_ZNAKOW_fk
  FOREIGN KEY (POLITYKA_ID)
  REFERENCES POLITYKA_BEZPIECZENSTWA (ID)
  ON DELETE CASCADE
  ON UPDATE NO ACTION;
  
ALTER TABLE PRACOWNIK_HISTORIA_HASLA ADD CONSTRAINT PRACOWNIK_PRACOWNIK_HISTORIA_HASLA_fk
  FOREIGN KEY (PRACOWNIK_ID)
  REFERENCES PRACOWNIK (ID)
  ON DELETE CASCADE
  ON UPDATE NO ACTION;

  
-- zmiany w tabeli pracownik
ALTER TABLE PRACOWNIK ADD ZABLOKOWANE BOOLEAN;

ALTER TABLE PRACOWNIK ADD DATA_ZMIANY_HASLA DATE;
UPDATE PRACOWNIK SET DATA_ZMIANY_HASLA = CURRENT_DATE() WHERE DATA_ZMIANY_HASLA IS NULL;
ALTER TABLE PRACOWNIK ALTER COLUMN DATA_ZMIANY_HASLA SET NOT NULL;

-- poprawki do widoku pracowników, którym umozliwiać logowanie
DROP VIEW IF EXISTS PRACOWNICY_AKTYWNI;
CREATE VIEW PRACOWNICY_AKTYWNI AS   
  SELECT pr.*
  FROM PRACOWNIK pr
  WHERE
        pr.CZY_PRACUJE = 1
        AND (pr.ZABLOKOWANE IS NULL OR pr.ZABLOKOWANE = FALSE)
        AND (pr.LICZBA_N_LOGOWAN < 3 OR pr.LICZBA_N_LOGOWAN IS NULL);

--//@UNDO
-- SQL to undo the change goes here.

