--// migracja wplaty rozliczanie.
-- Migration SQL that makes the change goes here.

-- ważne zwłaszcza przy ustalaniu kolejności spłat
ALTER TABLE PARAMETR_SYSTEMOWY ADD KOLEJNOSC INTEGER;

-- usuwanie wszystkich duplikatów parametrów systemowych (po przekształceniu ich na pojedyncze wartości)
DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_DEC_KIER'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_DEC_KIER';


DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_DOWOD_OS'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_DOWOD_OS';


DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_DEC_ALIM_ODPL'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_DEC_ALIM_ODPL';


DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_IPWM'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_IPWM';


DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_KONIEC_ZASILKU_STALEGO'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_KONIEC_ZASILKU_STALEGO';


DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_MELDUNKU'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_MELDUNKU';


DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_RECEPTY'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_RECEPTY';


DELETE FROM PARAMETR_SYSTEMOWY p
WHERE
	p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_UMOWA'
	AND EXISTS (
		SELECT t.*
		FROM PARAMETR_SYSTEMOWY t
		WHERE 
			t.TYP = p.TYP
			AND t.DATA_OD > p.DATA_DO
	);
UPDATE PARAMETR_SYSTEMOWY p
SET
	p.DATA_OD = null,
	p.DATA_DO = null
WHERE p.TYP = 'LICZBA_DNI_TERMIN_WAZNOSCI_UMOWA';


-- zmiany w fakturach
ALTER TABLE FAKTURA ADD STATUS VARCHAR(50);
UPDATE FAKTURA SET STATUS = 'ZATWIERDZONA' WHERE STATUS IS NULL;
ALTER TABLE FAKTURA ALTER COLUMN STATUS SET NOT NULL;

ALTER TABLE WPLATA ADD KWOTA_ZWROT DECIMAL(10,2);
UPDATE WPLATA SET KWOTA_ZWROT = '0.00' WHERE KWOTA_ZWROT IS NULL;
ALTER TABLE WPLATA ALTER COLUMN KWOTA_ZWROT SET NOT NULL;

-- zmiany we wpłatach
CREATE TABLE WPLATA_SZCZEGOLY (
    WPLATA_ID BIGINT(10) NOT NULL,
    NA_POCZET VARCHAR(50) NOT NULL,
    FAKTURA_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    MIESIAC INTEGER,
    ROK INTEGER,
    CONSTRAINT WPLATA_SZCZEGOLY_pk PRIMARY KEY (WPLATA_ID, NA_POCZET)
);

ALTER TABLE WPLATA_SZCZEGOLY ADD CONSTRAINT FAKTURA_WPLATA_SZCZEGOLY_fk
	FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE WPLATA_SZCZEGOLY ADD CONSTRAINT WPLATA_WPLATA_SZCZEGOLY_fk
	FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;

-- przenoszenie danych do szczegółów
INSERT INTO WPLATA_SZCZEGOLY(WPLATA_ID, NA_POCZET, FAKTURA_ID, KWOTA, ROK, MIESIAC)
	SELECT
		w.ID as WPLATA_ID,
		'CALOSC' as NA_POCZET,
		null as FAKTURA_ID,
		w.KWOTA,
		w.ROK,
		w.MIESIAC
	FROM WPLATA w;
	
-- poprawki we wpłatach
ALTER TABLE WPLATA DROP COLUMN ROK;
ALTER TABLE WPLATA DROP COLUMN MIESIAC;

	

--//@UNDO
-- SQL to undo the change goes here.

