--// migracja rozliczanie odplatnosci cd 2.
-- Migration SQL that makes the change goes here.

ALTER TABLE ZADLUZENIE_POZYCJA ADD KWOTA_ODSETEK DECIMAL(10,2);
UPDATE ZADLUZENIE_POZYCJA SET KWOTA_ODSETEK = 0.0;
ALTER TABLE ZADLUZENIE_POZYCJA ALTER COLUMN KWOTA_ODSETEK SET NOT NULL;

ALTER TABLE ZADLUZENIE_NA_DZIEN ADD KWOTA_ODSETEK DECIMAL(10,2);
UPDATE ZADLUZENIE_NA_DZIEN SET KWOTA_ODSETEK = 0.0;
ALTER TABLE ZADLUZENIE_NA_DZIEN ALTER COLUMN KWOTA_ODSETEK SET NOT NULL;

ALTER TABLE WPLATA_SKLADNIK ADD KWOTA_ODSETEK DECIMAL(10,2);
UPDATE WPLATA_SKLADNIK SET KWOTA_ODSETEK = 0.0;
ALTER TABLE WPLATA_SKLADNIK ALTER COLUMN KWOTA_ODSETEK SET NOT NULL;

ALTER TABLE ZADLUZENIE ADD AKTUALNOSC VARCHAR(50);
-- jeżeli choć jedna jest drity to ustaw dirty
UPDATE ZADLUZENIE z
	SET z.AKTUALNOSC = (
		SELECT tmp.*
		FROM (
			SELECT zp.AKTUALNOSC
			FROM ZADLUZENIE_POZYCJA zp
			WHERE zp.AKTUALNOSC = 'DIRTY'
			UNION
			SELECT zp.AKTUALNOSC
			FROM ZADLUZENIE_POZYCJA zp
			WHERE zp.AKTUALNOSC = 'ACTUAL'
		) as tmp
		LIMIT 1
		OFFSET 0
	)
	WHERE z.AKTUALNOSC IS NULL;
ALTER TABLE ZADLUZENIE ALTER COLUMN AKTUALNOSC SET NOT NULL;

-- trigger update aktualności zadłużenia
CREATE TRIGGER AUPD_ZADLUZENIE_POZYCJA AFTER
	UPDATE ON ZADLUZENIE_POZYCJA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.zadluzenie.AfterZadluzeniePozycjaUpdate";
CREATE TRIGGER AUPD_NALICZENIE_POBYT AFTER
	UPDATE ON NALICZENIE_POBYT FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.naliczanieOplat.pobyt.AfterNaliczaniePobytUpdate";

-- odpis zwrot
ALTER TABLE ODPIS_ZWROT ADD DATA DATE;
UPDATE ODPIS_ZWROT oz
	SET oz.DATA = (
		SELECT
			-- ostatni dzień miesiąca (czyli tutaj zrobione przez plus 1 miesiąc, minus 1 dzień)
			DATEADD('DAY_OF_YEAR', -1,
				DATEADD('MONTH', 1,
					PARSEDATETIME(CONCAT('', z.ROK, '-', z.MIESIAC, '-', 1), 'yyyy-MM-dd')))
		FROM ZADLUZENIE z
			JOIN ZADLUZENIE_POZYCJA zp ON z.ID = zp.ZADLUZENIE_ID
				AND zp.ID = oz.ZADLUZENIE_POZYCJA_ID
	)
	WHERE oz.DATA IS NULL;
ALTER TABLE ODPIS_ZWROT ALTER COLUMN DATA SET NOT NULL;


--//@UNDO
-- SQL to undo the change goes here.

