--// migracja nota odplatnosc rozliczenia zbiorcze struktura nowe.
-- Migration SQL that makes the change goes here.

-- status pozycji rozliczenia
ALTER TABLE NOTA_ODPLATNOSC ADD STATUS VARCHAR(50);
ALTER TABLE NOTA_ODPLATNOSC_POZYCJA ADD STATUS VARCHAR(50);

-- nowe tabele do struktury rozliczania
CREATE TABLE ZADLUZENIE_WYROWNANIE (
    ID IDENTITY NOT NULL,
    FAKTURA_ID BIGINT(10),
    NOTA_POZYCJA_ID BIGINT(10) NOT NULL,
    ODPIS_ID BIGINT(10),
    WPLATA_ID BIGINT(10),
    ZADLUZENIE_POZYCJA_ID BIGINT(10) NOT NULL,
    ZWROT_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    KWOTA_ODSETEK DECIMAL(10,2) NOT NULL,
    CONSTRAINT ZADLUZENIE_WYROWNANIE_pk PRIMARY KEY (ID)
);

ALTER TABLE ZADLUZENIE_WYROWNANIE ADD CONSTRAINT NOTA_ODPLATNOSC_POZYCJA_ZADLUZENIE_WYROWNANIE_fk
	FOREIGN KEY (NOTA_POZYCJA_ID)
	REFERENCES NOTA_ODPLATNOSC_POZYCJA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;

ALTER TABLE ZADLUZENIE_WYROWNANIE ADD CONSTRAINT ZADLUZENIE_POZYCJA_ZADLUZENIE_WYROWNANIE_fk
	FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZADLUZENIE_WYROWNANIE ADD CONSTRAINT FAKTURA_ZADLUZENIE_WYROWNANIE_fk
	FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZADLUZENIE_WYROWNANIE ADD CONSTRAINT ODPIS_ZADLUZENIE_WYROWNANIE_fk
	FOREIGN KEY (ODPIS_ID)
	REFERENCES ODPIS_ZWROT (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZADLUZENIE_WYROWNANIE ADD CONSTRAINT ZWROT_ZADLUZENIE_WYROWNANIE_fk
	FOREIGN KEY (ZWROT_ID)
	REFERENCES ODPIS_ZWROT (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZADLUZENIE_WYROWNANIE ADD CONSTRAINT WPLATA_ZADLUZENIE_WYROWNANIE_fk
	FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
--//@UNDO
-- SQL to undo the change goes here.

