--// migracja nota odplatnosc rozliczenia zbiorcze struktura nowe.
-- Migration SQL that makes the change goes here.

-- przenoszenie danych
INSERT INTO ZADLUZENIE_WYROWNANIE(FAKTURA_ID, NOTA_POZYCJA_ID, ODPIS_ID, WPLATA_ID, ZADLUZENIE_POZYCJA_ID, ZWROT_ID, KWOTA, KWOTA_ODSETEK)
	SELECT
		np.FAKTURA_ID, np.ID as NOTA_POZYCJA_ID, np.ODPIS_ID, np.WPLATA_ID,
		np.ZADLUZENIE_POZYCJA_ID, np.ZWROT_ID, np.KWOTA, np.KWOTA_ODSETEK
	FROM NOTA_ODPLATNOSC_POZYCJA np;

-- status pozycji noty
UPDATE NOTA_ODPLATNOSC_POZYCJA SET STATUS = 'ROZLICZONA' WHERE ID IN (
	SELECT np.ID
	FROM NOTA_ODPLATNOSC_POZYCJA np
	WHERE
		np.ODPIS_ID IS NOT NULL
		OR np.WPLATA_ID IS NOT NULL
		OR np.ZWROT_ID IS NOT NULL
		OR np.FAKTURA_ID IS NOT NULL
);

UPDATE NOTA_ODPLATNOSC_POZYCJA SET STATUS = 'W_REALIZACJI' WHERE STATUS IS NULL;

-- status noty (rozliczona wtedy gdy nie ma pozycji w realizacji)
UPDATE NOTA_ODPLATNOSC n SET n.STATUS = 'ROZLICZONA'
	WHERE NOT EXISTS (
		SELECT np.*
		FROM NOTA_ODPLATNOSC_POZYCJA np
		WHERE np.NOTA_ID = n.ID AND np.STATUS = 'W_REALIZACJI'
	);
-- status noty (rozliczona wtedy gdy nie ma pozycji w realizacji)
UPDATE NOTA_ODPLATNOSC n SET n.STATUS = 'W_REALIZACJI' WHERE n.STATUS IS NULL;


--//@UNDO
-- SQL to undo the change goes here.

