--// migracja odplatnosc naliczanie.
-- Migration SQL that makes the change goes here.

CREATE TABLE ODPLATNOSC_DOLICZENIE_POBYT (
    ID IDENTITY NOT NULL,
    ZADLUZENIE_POZYCJA_ID BIGINT(10) NOT NULL,
    KWOTA DECIMAL(10,2) NOT NULL,
    STATUS VARCHAR(50) NOT NULL,
    CONSTRAINT ODPLATNOSC_DOLICZENIE_POBYT_pk PRIMARY KEY (ID)
);

CREATE TABLE ODPLATNOSC_AKTUALIZACJA (
    ID IDENTITY NOT NULL,
    OSOBA_ID BIGINT(10) NOT NULL,
    DATA_OD DATE NOT NULL,
    CONSTRAINT ODPLATNOSC_AKTUALIZACJA_pk PRIMARY KEY (ID)
);

ALTER TABLE NALICZENIE_POBYT ADD DOLICZENIE_ID BIGINT(10);

ALTER TABLE ODPLATNOSC_DOLICZENIE_POBYT ADD CONSTRAINT ZADLUZENIE_POZYCJA_ODPLATNOSC_DOLICZENIE_POBYT_fk
	FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;

ALTER TABLE NALICZENIE_POBYT ADD CONSTRAINT ODPLATNOSC_DOLICZENIE_POBYT_NALICZENIE_POBYT_fk
	FOREIGN KEY (DOLICZENIE_ID)
	REFERENCES ODPLATNOSC_DOLICZENIE_POBYT (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
	
ALTER TABLE ODPLATNOSC_AKTUALIZACJA ADD CONSTRAINT OSOBA_ODPLATNOSC_AKTUALIZACJA_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

-- pojedynczy wpis dla osoby
CREATE UNIQUE INDEX OA_UNIKALNA_OSOBA
	ON ODPLATNOSC_AKTUALIZACJA(OSOBA_ID);
	
-- stan danych (o doliczeniach)
INSERT INTO ODPLATNOSC_AKTUALIZACJA(OSOBA_ID, DATA_OD)
	SELECT dk.OSOBA_ID, MIN(o.DATA_OD) as DATA_OD
	FROM DECYZJA_KIERUJACA dk
		JOIN ODPLATNOSC o ON dk.ID = o.DECYZJA_KIERUJACA_ID
	GROUP BY dk.OSOBA_ID;

-- Quartz - zadania aktualizacji danych

-- doliczenia do płatności (wstawianie nowego okresu)
INSERT INTO QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION,
		JOB_CLASS_NAME, IS_DURABLE, IS_UPDATE_DATA, IS_NONCONCURRENT, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
	VALUES('QuartzServer', 'DoliczeniePobytNowyOkres', 'NARZEDZIOWE', 'Dopisywanie nowego okresu do obliczeń',
		'pl.topteam.dps.timeTask.odplatnosc.DoliczeniePobytNowyOkres', 'FALSE', 'FALSE', 'FALSE', 'FALSE', '', false);

INSERT INTO QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP,
		DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, MISFIRE_INSTR)
	VALUES('QuartzServer', 'WyzwalaczDoliczeniePobytNowyOkres', 'NARZEDZIOWE', 'DoliczeniePobytNowyOkres', 'NARZEDZIOWE',
		'Dopisywanie nowego okresu do obliczeń', 1276514580000, 1276514570000, 5, 'ACQUIRED', 'CRON', 1276512961000, 0, 1);

INSERT INTO QRTZ_CRON_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)
	VALUES('QuartzServer', 'WyzwalaczDoliczeniePobytNowyOkres', 'NARZEDZIOWE', '0 0 1 L * ?', 'Europe/Belgrade');

-- doliczenia do płatności (wyliczanie samych kwot)
INSERT INTO QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION,
		JOB_CLASS_NAME, IS_DURABLE, IS_UPDATE_DATA, IS_NONCONCURRENT, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
	VALUES('QuartzServer', 'DoliczeniePobyt', 'NARZEDZIOWE', 'Aktualizuje dane nt. kwot doliczeń za pobyt',
		'pl.topteam.dps.timeTask.odplatnosc.DoliczeniePobyt', 'FALSE', 'FALSE', 'FALSE', 'FALSE', '', false);

INSERT INTO QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP,
		DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, MISFIRE_INSTR)
	VALUES('QuartzServer', 'WyzwalaczDoliczeniePobyt', 'NARZEDZIOWE', 'DoliczeniePobyt', 'NARZEDZIOWE',
		'Aktualizuje dane nt. kwot doliczeń za pobyt', 1276514580000, 1276514570000, 5, 'ACQUIRED', 'CRON', 1276512961000, 0, 1);

INSERT INTO QRTZ_CRON_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)
	VALUES('QuartzServer', 'WyzwalaczDoliczeniePobyt', 'NARZEDZIOWE', '0 0 0/2 * * ?', 'Europe/Belgrade');
	
	
--//@UNDO
-- SQL to undo the change goes here.

