--// migracja data zgonu osoby.
-- Migration SQL that makes the change goes here.

ALTER TABLE OSOBA ADD DATA_ZGONU DATE;

UPDATE OSOBA o SET o.DATA_ZGONU = (
	SELECT ew.DATA_OD
	FROM EWIDENCJA_DPS ew
	WHERE ew.OSOBA_ID = o.ID
		AND (ew.TYP  = 'MIESZKANIEC_ZGON' OR ew.TYP = 'OSOBA_OCZEKUJACA_ZGON')
);


-- ewidencja
CREATE TRIGGER AINS_EWIDENCJA_DPS AFTER
	INSERT ON EWIDENCJA_DPS FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.ewidencja.AfterEwidencjaDpsInsert";
CREATE TRIGGER AUPD_EWIDENCJA_DPS AFTER
	UPDATE ON EWIDENCJA_DPS FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.ewidencja.AfterEwidencjaDpsUpdate";
CREATE TRIGGER ADEL_EWIDENCJA_DPS AFTER
	DELETE ON EWIDENCJA_DPS FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.ewidencja.AfterEwidencjaDpsDelete";

-- poprawki w widokach
DROP VIEW IF EXISTS MIESZKANCY;

CREATE VIEW MIESZKANCY AS
	SELECT os.*, ew.id as EWIDENCJA_ID, ew.DATA_OD, ew.DATA_DO, ew.NUMER_EWIDENCYJNY
	FROM OSOBA os
    	JOIN EWIDENCJA_DPS ew ON os.id = ew.osoba_id
			AND ew.TYP = 'MIESZKANIEC';


--//@UNDO
-- SQL to undo the change goes here.

